/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RecordInput
extends PrimitiveOp
implements Operand<String> {
    private Output<String> records;

    public static RecordInput create(Scope scope, String filePattern, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("RecordInput", scope.makeOpName("RecordInput"));
        operationBuilder.setAttr("file_pattern", filePattern);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.fileRandomSeed != null) {
                    operationBuilder.setAttr("file_random_seed", options2.fileRandomSeed);
                }
                if (options2.fileShuffleShiftRatio != null) {
                    operationBuilder.setAttr("file_shuffle_shift_ratio", options2.fileShuffleShiftRatio.floatValue());
                }
                if (options2.fileBufferSize != null) {
                    operationBuilder.setAttr("file_buffer_size", options2.fileBufferSize);
                }
                if (options2.fileParallelism != null) {
                    operationBuilder.setAttr("file_parallelism", options2.fileParallelism);
                }
                if (options2.batchSize != null) {
                    operationBuilder.setAttr("batch_size", options2.batchSize);
                }
                if (options2.compressionType == null) continue;
                operationBuilder.setAttr("compression_type", options2.compressionType);
            }
        }
        return new RecordInput(operationBuilder.build());
    }

    public static Options fileRandomSeed(Long fileRandomSeed) {
        return new Options().fileRandomSeed(fileRandomSeed);
    }

    public static Options fileShuffleShiftRatio(Float fileShuffleShiftRatio) {
        return new Options().fileShuffleShiftRatio(fileShuffleShiftRatio);
    }

    public static Options fileBufferSize(Long fileBufferSize) {
        return new Options().fileBufferSize(fileBufferSize);
    }

    public static Options fileParallelism(Long fileParallelism) {
        return new Options().fileParallelism(fileParallelism);
    }

    public static Options batchSize(Long batchSize) {
        return new Options().batchSize(batchSize);
    }

    public static Options compressionType(String compressionType) {
        return new Options().compressionType(compressionType);
    }

    public final Output<String> records() {
        return this.records;
    }

    @Override
    public final Output<String> asOutput() {
        return this.records;
    }

    private RecordInput(Operation operation) {
        super(operation);
        this.records = operation.output(0);
    }

    public static class Options {
        private Long fileRandomSeed;
        private Float fileShuffleShiftRatio;
        private Long fileBufferSize;
        private Long fileParallelism;
        private Long batchSize;
        private String compressionType;

        public Options fileRandomSeed(Long fileRandomSeed) {
            this.fileRandomSeed = fileRandomSeed;
            return this;
        }

        public Options fileShuffleShiftRatio(Float fileShuffleShiftRatio) {
            this.fileShuffleShiftRatio = fileShuffleShiftRatio;
            return this;
        }

        public Options fileBufferSize(Long fileBufferSize) {
            this.fileBufferSize = fileBufferSize;
            return this;
        }

        public Options fileParallelism(Long fileParallelism) {
            this.fileParallelism = fileParallelism;
            return this;
        }

        public Options batchSize(Long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Options compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        private Options() {
        }
    }
}

