/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseConditionalAccumulator
extends PrimitiveOp
implements Operand<String> {
    private Output<String> handle;

    public static <T> SparseConditionalAccumulator create(Scope scope, Class<T> dtype, Shape shape, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseConditionalAccumulator", scope.makeOpName("SparseConditionalAccumulator"));
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        operationBuilder.setAttr("shape", shape);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName != null) {
                    operationBuilder.setAttr("shared_name", options2.sharedName);
                }
                if (options2.reductionType == null) continue;
                operationBuilder.setAttr("reduction_type", options2.reductionType);
            }
        }
        return new SparseConditionalAccumulator(operationBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options reductionType(String reductionType) {
        return new Options().reductionType(reductionType);
    }

    public final Output<String> handle() {
        return this.handle;
    }

    @Override
    public final Output<String> asOutput() {
        return this.handle;
    }

    private SparseConditionalAccumulator(Operation operation) {
        super(operation);
        this.handle = operation.output(0);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private String reductionType;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options reductionType(String reductionType) {
            this.reductionType = reductionType;
            return this;
        }

        private Options() {
        }
    }
}

