/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class StringSplit
extends PrimitiveOp {
    private Output<Long> indices;
    private Output<String> values;
    private Output<Long> shape;

    public static StringSplit create(Scope scope, Operand<String> input, Operand<String> delimiter, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("StringSplit", scope.makeOpName("StringSplit"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(delimiter.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.skipEmpty == null) continue;
                operationBuilder.setAttr("skip_empty", options2.skipEmpty);
            }
        }
        return new StringSplit(operationBuilder.build());
    }

    public static Options skipEmpty(Boolean skipEmpty) {
        return new Options().skipEmpty(skipEmpty);
    }

    public final Output<Long> indices() {
        return this.indices;
    }

    public final Output<String> values() {
        return this.values;
    }

    public final Output<Long> shape() {
        return this.shape;
    }

    private StringSplit(Operation operation) {
        super(operation);
        this.indices = operation.output(0);
        this.values = operation.output(1);
        this.shape = operation.output(2);
    }

    public static class Options {
        private Boolean skipEmpty;

        public Options skipEmpty(Boolean skipEmpty) {
            this.skipEmpty = skipEmpty;
            return this;
        }

        private Options() {
        }
    }
}

