/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TopK<T extends Number>
extends PrimitiveOp {
    private Output<T> values;
    private Output<Integer> indices;

    public static <T extends Number> TopK<T> create(Scope scope, Operand<T> input, Operand<Integer> k2, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("TopKV2", scope.makeOpName("TopK"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(k2.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.sorted == null) continue;
                operationBuilder.setAttr("sorted", options2.sorted);
            }
        }
        return new TopK<T>(operationBuilder.build());
    }

    public static Options sorted(Boolean sorted) {
        return new Options().sorted(sorted);
    }

    public final Output<T> values() {
        return this.values;
    }

    public final Output<Integer> indices() {
        return this.indices;
    }

    private TopK(Operation operation) {
        super(operation);
        this.values = operation.output(0);
        this.indices = operation.output(1);
    }

    public static class Options {
        private Boolean sorted;

        public Options sorted(Boolean sorted) {
            this.sorted = sorted;
            return this;
        }

        private Options() {
        }
    }
}

