/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Variable<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> ref;

    public static <T> Variable<T> create(Scope scope, Shape shape, Class<T> dtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("VariableV2", scope.makeOpName("Variable"));
        operationBuilder.setAttr("shape", shape);
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName == null) continue;
                operationBuilder.setAttr("shared_name", options2.sharedName);
            }
        }
        return new Variable<T>(operationBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public final Output<T> ref() {
        return this.ref;
    }

    @Override
    public final Output<T> asOutput() {
        return this.ref;
    }

    private Variable(Operation operation) {
        super(operation);
        this.ref = operation.output(0);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

