/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.nio.ByteBuffer;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Op;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;

public class Zeros<T>
implements Operand<T>,
Op {
    private final Fill<T> fill;

    public static <T, U extends Number> Zeros<T> create(Scope scope, Operand<U> dims, Class<T> type) {
        Scope scope2 = scope.withSubScope("Zeros");
        int n2 = DataType.fromClass(type).byteSize();
        if (n2 < 0) {
            throw new IllegalArgumentException(type.getSimpleName() + " tensors cannot be initialized with zeros");
        }
        Constant<T> constant = Constant.create(scope2.withName("Zero"), type, new long[0], ByteBuffer.allocate(n2));
        return new Zeros<T>(Fill.create(scope2, dims, constant));
    }

    @Override
    public Output<T> asOutput() {
        return this.fill.asOutput();
    }

    private Zeros(Fill<T> fill) {
        this.fill = fill;
    }
}

