/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.DuplicateMemberException;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.InnerClassesAttribute;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.SourceFileAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class ClassFile {
    int major;
    int minor;
    ConstPool constPool;
    int thisClass;
    int accessFlags;
    int superClass;
    int[] interfaces;
    List<FieldInfo> fields;
    List<MethodInfo> methods;
    List<AttributeInfo> attributes;
    String thisclassname;
    String[] cachedInterfaces;
    String cachedSuperclass;
    public static final int JAVA_1 = 45;
    public static final int JAVA_2 = 46;
    public static final int JAVA_3 = 47;
    public static final int JAVA_4 = 48;
    public static final int JAVA_5 = 49;
    public static final int JAVA_6 = 50;
    public static final int JAVA_7 = 51;
    public static final int JAVA_8 = 52;
    public static final int JAVA_9 = 53;
    public static final int JAVA_10 = 54;
    public static final int JAVA_11 = 55;
    public static final int MAJOR_VERSION;

    public ClassFile(DataInputStream in) throws IOException {
        this.read(in);
    }

    public ClassFile(boolean isInterface, String classname, String superclass) {
        this.major = MAJOR_VERSION;
        this.minor = 0;
        this.constPool = new ConstPool(classname);
        this.thisClass = this.constPool.getThisClassInfo();
        this.accessFlags = isInterface ? 1536 : 32;
        this.initSuperclass(superclass);
        this.interfaces = null;
        this.fields = new ArrayList<FieldInfo>();
        this.methods = new ArrayList<MethodInfo>();
        this.thisclassname = classname;
        this.attributes = new ArrayList<AttributeInfo>();
        this.attributes.add(new SourceFileAttribute(this.constPool, ClassFile.getSourcefileName(this.thisclassname)));
    }

    private void initSuperclass(String superclass) {
        if (superclass != null) {
            this.superClass = this.constPool.addClassInfo(superclass);
            this.cachedSuperclass = superclass;
            return;
        }
        this.superClass = this.constPool.addClassInfo("java.lang.Object");
        this.cachedSuperclass = "java.lang.Object";
    }

    private static String getSourcefileName(String qname) {
        return qname.replaceAll("^.*\\.", "") + ".java";
    }

    public final void compact() {
        ConstPool constPool = this.compact0();
        for (MethodInfo object : this.methods) {
            object.compact(constPool);
        }
        for (FieldInfo fieldInfo : this.fields) {
            fieldInfo.compact(constPool);
        }
        this.attributes = AttributeInfo.copyAll(this.attributes, constPool);
        this.constPool = constPool;
    }

    private ConstPool compact0() {
        ConstPool constPool = new ConstPool(this.thisclassname);
        this.thisClass = constPool.getThisClassInfo();
        String string = this.getSuperclass();
        if (string != null) {
            this.superClass = constPool.addClassInfo(this.getSuperclass());
        }
        if (this.interfaces != null) {
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                this.interfaces[i2] = constPool.addClassInfo(this.constPool.getClassInfo(this.interfaces[i2]));
            }
        }
        return constPool;
    }

    public final void prune() {
        AttributeInfo attributeInfo;
        AttributeInfo attributeInfo2;
        ConstPool constPool = this.compact0();
        ArrayList<AttributeInfo> arrayList = new ArrayList<AttributeInfo>();
        AttributeInfo attributeInfo3 = this.getAttribute("RuntimeInvisibleAnnotations");
        if (attributeInfo3 != null) {
            attributeInfo3 = attributeInfo3.copy(constPool, null);
            arrayList.add(attributeInfo3);
        }
        if ((attributeInfo2 = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            attributeInfo2 = attributeInfo2.copy(constPool, null);
            arrayList.add(attributeInfo2);
        }
        if ((attributeInfo = this.getAttribute("Signature")) != null) {
            attributeInfo = attributeInfo.copy(constPool, null);
            arrayList.add(attributeInfo);
        }
        for (MethodInfo object : this.methods) {
            object.prune(constPool);
        }
        for (FieldInfo fieldInfo : this.fields) {
            fieldInfo.prune(constPool);
        }
        this.attributes = arrayList;
        this.constPool = constPool;
    }

    public final ConstPool getConstPool() {
        return this.constPool;
    }

    public final boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public final void setAccessFlags(int acc) {
        if ((acc & 0x200) == 0) {
            acc |= 0x20;
        }
        this.accessFlags = acc;
    }

    public final int getInnerAccessFlags() {
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)this.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            return -1;
        }
        String string = this.getName();
        int n2 = innerClassesAttribute.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equals(innerClassesAttribute.innerClass(i2))) continue;
            return innerClassesAttribute.accessFlags(i2);
        }
        return -1;
    }

    public final String getName() {
        return this.thisclassname;
    }

    public final void setName(String name) {
        ClassFile classFile = this;
        classFile.renameClass(classFile.thisclassname, name);
    }

    public final String getSuperclass() {
        if (this.cachedSuperclass == null) {
            this.cachedSuperclass = this.constPool.getClassInfo(this.superClass);
        }
        return this.cachedSuperclass;
    }

    public final int getSuperclassId() {
        return this.superClass;
    }

    public final void setSuperclass(String superclass) throws CannotCompileException {
        if (superclass == null) {
            superclass = "java.lang.Object";
        }
        try {
            this.superClass = this.constPool.addClassInfo(superclass);
            for (MethodInfo methodInfo : this.methods) {
                methodInfo.setSuperclass(superclass);
            }
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
        this.cachedSuperclass = superclass;
    }

    public final void renameClass(String oldname, String newname) {
        String string;
        if (oldname.equals(newname)) {
            return;
        }
        if (oldname.equals(this.thisclassname)) {
            this.thisclassname = newname;
        }
        oldname = Descriptor.toJvmName(oldname);
        newname = Descriptor.toJvmName(newname);
        this.constPool.renameClass(oldname, newname);
        AttributeInfo.renameClass(this.attributes, oldname, newname);
        for (MethodInfo object : this.methods) {
            string = object.getDescriptor();
            object.setDescriptor(Descriptor.rename(string, oldname, newname));
            AttributeInfo.renameClass(object.getAttributes(), oldname, newname);
        }
        for (FieldInfo fieldInfo : this.fields) {
            string = fieldInfo.getDescriptor();
            fieldInfo.setDescriptor(Descriptor.rename(string, oldname, newname));
            AttributeInfo.renameClass(fieldInfo.getAttributes(), oldname, newname);
        }
    }

    public final void renameClass(Map<String, String> classnames) {
        String string;
        String string2 = classnames.get(Descriptor.toJvmName(this.thisclassname));
        if (string2 != null) {
            this.thisclassname = Descriptor.toJavaName(string2);
        }
        this.constPool.renameClass(classnames);
        AttributeInfo.renameClass(this.attributes, classnames);
        for (MethodInfo object : this.methods) {
            string = object.getDescriptor();
            object.setDescriptor(Descriptor.rename(string, classnames));
            AttributeInfo.renameClass(object.getAttributes(), classnames);
        }
        for (FieldInfo fieldInfo : this.fields) {
            string = fieldInfo.getDescriptor();
            fieldInfo.setDescriptor(Descriptor.rename(string, classnames));
            AttributeInfo.renameClass(fieldInfo.getAttributes(), classnames);
        }
    }

    public final void getRefClasses(Map<String, String> classnames) {
        String string;
        this.constPool.renameClass(classnames);
        AttributeInfo.getRefClasses(this.attributes, classnames);
        for (MethodInfo object : this.methods) {
            string = object.getDescriptor();
            Descriptor.rename(string, classnames);
            AttributeInfo.getRefClasses(object.getAttributes(), classnames);
        }
        for (FieldInfo fieldInfo : this.fields) {
            string = fieldInfo.getDescriptor();
            Descriptor.rename(string, classnames);
            AttributeInfo.getRefClasses(fieldInfo.getAttributes(), classnames);
        }
    }

    public final String[] getInterfaces() {
        String[] stringArray;
        if (this.cachedInterfaces != null) {
            return this.cachedInterfaces;
        }
        if (this.interfaces == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[this.interfaces.length];
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                stringArray2[i2] = this.constPool.getClassInfo(this.interfaces[i2]);
            }
            stringArray = stringArray2;
        }
        this.cachedInterfaces = stringArray;
        return stringArray;
    }

    public final void setInterfaces(String[] nameList) {
        this.cachedInterfaces = null;
        if (nameList != null) {
            this.interfaces = new int[nameList.length];
            for (int i2 = 0; i2 < nameList.length; ++i2) {
                this.interfaces[i2] = this.constPool.addClassInfo(nameList[i2]);
            }
        }
    }

    public final void addInterface(String name) {
        this.cachedInterfaces = null;
        int n2 = this.constPool.addClassInfo(name);
        if (this.interfaces == null) {
            this.interfaces = new int[1];
            this.interfaces[0] = n2;
            return;
        }
        int n3 = this.interfaces.length;
        int[] nArray = new int[n3 + 1];
        System.arraycopy(this.interfaces, 0, nArray, 0, n3);
        nArray[n3] = n2;
        this.interfaces = nArray;
    }

    public final List<FieldInfo> getFields() {
        return this.fields;
    }

    public final void addField(FieldInfo finfo) throws DuplicateMemberException {
        this.testExistingField(finfo.getName(), finfo.getDescriptor());
        this.fields.add(finfo);
    }

    public final void addField2(FieldInfo finfo) {
        this.fields.add(finfo);
    }

    private void testExistingField(String name, String descriptor) throws DuplicateMemberException {
        for (FieldInfo fieldInfo : this.fields) {
            if (!fieldInfo.getName().equals(name)) continue;
            throw new DuplicateMemberException("duplicate field: " + name);
        }
    }

    public final List<MethodInfo> getMethods() {
        return this.methods;
    }

    public final MethodInfo getMethod(String name) {
        for (MethodInfo methodInfo : this.methods) {
            if (!methodInfo.getName().equals(name)) continue;
            return methodInfo;
        }
        return null;
    }

    public final MethodInfo getStaticInitializer() {
        return this.getMethod("<clinit>");
    }

    public final void addMethod(MethodInfo minfo) throws DuplicateMemberException {
        this.testExistingMethod(minfo);
        this.methods.add(minfo);
    }

    public final void addMethod2(MethodInfo minfo) {
        this.methods.add(minfo);
    }

    private void testExistingMethod(MethodInfo newMinfo) throws DuplicateMemberException {
        String string = newMinfo.getName();
        String string2 = newMinfo.getDescriptor();
        ListIterator<MethodInfo> listIterator = this.methods.listIterator(0);
        while (listIterator.hasNext()) {
            if (!ClassFile.isDuplicated(newMinfo, string, string2, listIterator.next(), listIterator)) continue;
            throw new DuplicateMemberException("duplicate method: " + string + " in " + this.getName());
        }
    }

    private static boolean isDuplicated(MethodInfo newMethod, String newName, String newDesc, MethodInfo minfo, ListIterator<MethodInfo> it) {
        if (!minfo.getName().equals(newName)) {
            return false;
        }
        String string = minfo.getDescriptor();
        if (!Descriptor.eqParamTypes(string, newDesc)) {
            return false;
        }
        if (string.equals(newDesc)) {
            if (ClassFile.notBridgeMethod(minfo)) {
                return true;
            }
            it.remove();
            return false;
        }
        return false;
    }

    private static boolean notBridgeMethod(MethodInfo minfo) {
        return (minfo.getAccessFlags() & 0x40) == 0;
    }

    public final List<AttributeInfo> getAttributes() {
        return this.attributes;
    }

    public final AttributeInfo getAttribute(String name) {
        for (AttributeInfo attributeInfo : this.attributes) {
            if (!attributeInfo.getName().equals(name)) continue;
            return attributeInfo;
        }
        return null;
    }

    public final AttributeInfo removeAttribute(String name) {
        return AttributeInfo.remove(this.attributes, name);
    }

    public final void addAttribute(AttributeInfo info) {
        AttributeInfo.remove(this.attributes, info.getName());
        this.attributes.add(info);
    }

    public final String getSourceFile() {
        SourceFileAttribute sourceFileAttribute = (SourceFileAttribute)this.getAttribute("SourceFile");
        if (sourceFileAttribute == null) {
            return null;
        }
        return sourceFileAttribute.getFileName();
    }

    private void read(DataInputStream in) throws IOException {
        int n2;
        int n3 = in.readInt();
        if (n3 != -889275714) {
            throw new IOException("bad magic number: " + Integer.toHexString(n3));
        }
        this.minor = in.readUnsignedShort();
        this.major = in.readUnsignedShort();
        this.constPool = new ConstPool(in);
        this.accessFlags = in.readUnsignedShort();
        this.thisClass = in.readUnsignedShort();
        this.constPool.setThisClassInfo(this.thisClass);
        this.superClass = in.readUnsignedShort();
        int n4 = in.readUnsignedShort();
        if (n4 == 0) {
            this.interfaces = null;
        } else {
            this.interfaces = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                this.interfaces[n2] = in.readUnsignedShort();
            }
        }
        ConstPool constPool = this.constPool;
        n4 = in.readUnsignedShort();
        this.fields = new ArrayList<FieldInfo>();
        for (n2 = 0; n2 < n4; ++n2) {
            this.addField2(new FieldInfo(constPool, in));
        }
        n4 = in.readUnsignedShort();
        this.methods = new ArrayList<MethodInfo>();
        for (n2 = 0; n2 < n4; ++n2) {
            this.addMethod2(new MethodInfo(constPool, in));
        }
        this.attributes = new ArrayList<AttributeInfo>();
        n4 = in.readUnsignedShort();
        for (n2 = 0; n2 < n4; ++n2) {
            this.addAttribute(AttributeInfo.read(constPool, in));
        }
        this.thisclassname = this.constPool.getClassInfo(this.thisClass);
    }

    public final void write(DataOutputStream out) throws IOException {
        int n2;
        out.writeInt(-889275714);
        out.writeShort(this.minor);
        out.writeShort(this.major);
        this.constPool.write(out);
        out.writeShort(this.accessFlags);
        out.writeShort(this.thisClass);
        out.writeShort(this.superClass);
        int n3 = this.interfaces == null ? 0 : this.interfaces.length;
        out.writeShort(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            out.writeShort(this.interfaces[n2]);
        }
        n3 = this.fields.size();
        out.writeShort(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            FieldInfo fieldInfo = this.fields.get(n2);
            fieldInfo.write(out);
        }
        out.writeShort(this.methods.size());
        for (MethodInfo methodInfo : this.methods) {
            methodInfo.write(out);
        }
        out.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, out);
    }

    public final int getMajorVersion() {
        return this.major;
    }

    public final void setMajorVersion(int major) {
        this.major = major;
    }

    public final int getMinorVersion() {
        return this.minor;
    }

    public final void setMinorVersion(int minor) {
        this.minor = minor;
    }

    public final void setVersionToJava5() {
        this.major = 49;
        this.minor = 0;
    }

    static {
        int n2 = 47;
        try {
            Class.forName("java.lang.StringBuilder");
            n2 = 49;
            Class.forName("java.util.zip.DeflaterInputStream");
            n2 = 50;
            Class.forName("java.lang.invoke.CallSite", false, ClassLoader.getSystemClassLoader());
            n2 = 51;
            Class.forName("java.util.function.Function");
            n2 = 52;
            Class.forName("java.lang.Module");
            n2 = 53;
            List.class.getMethod("copyOf", Collection.class);
            n2 = 54;
            Class.forName("java.util.Optional").getMethod("isEmpty", new Class[0]);
            n2 = 55;
        }
        catch (Throwable throwable) {}
        MAJOR_VERSION = n2;
    }
}

