/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtPrimitiveType;
import ai.h2o.javassist.NotFoundException;
import java.util.Map;

public class Descriptor {
    public static String toJvmName(String classname) {
        return classname.replace('.', '/');
    }

    public static String toJavaName(String classname) {
        return classname.replace('/', '.');
    }

    public static String toJvmName(CtClass clazz) {
        if (clazz.isArray()) {
            return Descriptor.of(clazz);
        }
        return Descriptor.toJvmName(clazz.getName());
    }

    public static String toClassName(String descriptor) {
        String string;
        int n2 = 0;
        int n3 = 0;
        char c2 = descriptor.charAt(0);
        while (c2 == '[') {
            ++n2;
            c2 = descriptor.charAt(++n3);
        }
        if (c2 == 'L') {
            int n4 = descriptor.indexOf(59, n3++);
            string = descriptor.substring(n3, n4).replace('/', '.');
            n3 = n4;
        } else if (c2 == 'V') {
            string = "void";
        } else if (c2 == 'I') {
            string = "int";
        } else if (c2 == 'B') {
            string = "byte";
        } else if (c2 == 'J') {
            string = "long";
        } else if (c2 == 'D') {
            string = "double";
        } else if (c2 == 'F') {
            string = "float";
        } else if (c2 == 'C') {
            string = "char";
        } else if (c2 == 'S') {
            string = "short";
        } else if (c2 == 'Z') {
            string = "boolean";
        } else {
            throw new RuntimeException("bad descriptor: " + descriptor);
        }
        if (n3 + 1 != descriptor.length()) {
            throw new RuntimeException("multiple descriptors?: " + descriptor);
        }
        if (n2 == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        do {
            stringBuffer.append("[]");
        } while (--n2 > 0);
        return stringBuffer.toString();
    }

    public static String of(String classname) {
        if (classname.equals("void")) {
            return "V";
        }
        if (classname.equals("int")) {
            return "I";
        }
        if (classname.equals("byte")) {
            return "B";
        }
        if (classname.equals("long")) {
            return "J";
        }
        if (classname.equals("double")) {
            return "D";
        }
        if (classname.equals("float")) {
            return "F";
        }
        if (classname.equals("char")) {
            return "C";
        }
        if (classname.equals("short")) {
            return "S";
        }
        if (classname.equals("boolean")) {
            return "Z";
        }
        return "L" + Descriptor.toJvmName(classname) + ";";
    }

    public static String rename(String desc, String oldname, String newname) {
        int n2;
        if (desc.indexOf(oldname) < 0) {
            return desc;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while ((n2 = desc.indexOf(76, n4)) >= 0) {
            if (desc.startsWith(oldname, n2 + 1) && desc.charAt(n2 + oldname.length() + 1) == ';') {
                stringBuffer.append(desc.substring(n3, n2));
                stringBuffer.append('L');
                stringBuffer.append(newname);
                stringBuffer.append(';');
                n3 = n4 = n2 + oldname.length() + 2;
                continue;
            }
            n4 = desc.indexOf(59, n2) + 1;
            if (n4 > 0) continue;
            break;
        }
        if (n3 == 0) {
            return desc;
        }
        n2 = desc.length();
        if (n3 < n2) {
            stringBuffer.append(desc.substring(n3, n2));
        }
        return stringBuffer.toString();
    }

    public static String rename(String desc, Map<String, String> map) {
        int n2;
        int n3;
        if (map == null) {
            return desc;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        int n5 = 0;
        while ((n3 = desc.indexOf(76, n5)) >= 0 && (n2 = desc.indexOf(59, n3)) >= 0) {
            n5 = n2 + 1;
            String string = desc.substring(n3 + 1, n2);
            String string2 = map.get(string);
            if (string2 == null) continue;
            stringBuffer.append(desc.substring(n4, n3));
            stringBuffer.append('L');
            stringBuffer.append(string2);
            stringBuffer.append(';');
            n4 = n5;
        }
        if (n4 == 0) {
            return desc;
        }
        n3 = desc.length();
        if (n4 < n3) {
            stringBuffer.append(desc.substring(n4, n3));
        }
        return stringBuffer.toString();
    }

    public static String of(CtClass type) {
        StringBuffer stringBuffer = new StringBuffer();
        Descriptor.toDescriptor(stringBuffer, type);
        return stringBuffer.toString();
    }

    private static void toDescriptor(StringBuffer desc, CtClass type) {
        if (type.isArray()) {
            desc.append('[');
            try {
                Descriptor.toDescriptor(desc, type.getComponentType());
                return;
            }
            catch (NotFoundException notFoundException) {
                desc.append('L');
                String string = type.getName();
                desc.append(Descriptor.toJvmName(string.substring(0, string.length() - 2)));
                desc.append(';');
                return;
            }
        }
        if (type.isPrimitive()) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)type;
            desc.append(ctPrimitiveType.getDescriptor());
            return;
        }
        desc.append('L');
        desc.append(type.getName().replace('.', '/'));
        desc.append(';');
    }

    public static String ofConstructor(CtClass[] paramTypes) {
        return Descriptor.ofMethod(CtClass.voidType, paramTypes);
    }

    public static String ofMethod(CtClass returnType, CtClass[] paramTypes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (paramTypes != null) {
            int n2 = paramTypes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Descriptor.toDescriptor(stringBuffer, paramTypes[i2]);
            }
        }
        stringBuffer.append(')');
        if (returnType != null) {
            Descriptor.toDescriptor(stringBuffer, returnType);
        }
        return stringBuffer.toString();
    }

    public static String ofParameters(CtClass[] paramTypes) {
        return Descriptor.ofMethod(null, paramTypes);
    }

    public static String appendParameter(String classname, String desc) {
        int n2 = desc.indexOf(41);
        if (n2 < 0) {
            return desc;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(desc.substring(0, n2));
        stringBuffer.append('L');
        stringBuffer.append(classname.replace('.', '/'));
        stringBuffer.append(';');
        stringBuffer.append(desc.substring(n2));
        return stringBuffer.toString();
    }

    public static String insertParameter(String classname, String desc) {
        if (desc.charAt(0) != '(') {
            return desc;
        }
        return "(L" + classname.replace('.', '/') + ';' + desc.substring(1);
    }

    public static String appendParameter(CtClass type, String descriptor) {
        int n2 = descriptor.indexOf(41);
        if (n2 < 0) {
            return descriptor;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(descriptor.substring(0, n2));
        Descriptor.toDescriptor(stringBuffer, type);
        stringBuffer.append(descriptor.substring(n2));
        return stringBuffer.toString();
    }

    public static String insertParameter(CtClass type, String descriptor) {
        if (descriptor.charAt(0) != '(') {
            return descriptor;
        }
        return "(" + Descriptor.of(type) + descriptor.substring(1);
    }

    public static String changeReturnType(String classname, String desc) {
        int n2 = desc.indexOf(41);
        if (n2 < 0) {
            return desc;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(desc.substring(0, n2 + 1));
        stringBuffer.append('L');
        stringBuffer.append(classname.replace('.', '/'));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public static CtClass[] getParameterTypes(String desc, ClassPool cp) throws NotFoundException {
        if (desc.charAt(0) != '(') {
            return null;
        }
        int n2 = Descriptor.numOfParameters(desc);
        CtClass[] ctClassArray = new CtClass[n2];
        int n3 = 0;
        int n4 = 1;
        while ((n4 = Descriptor.toCtClass(cp, desc, n4, ctClassArray, n3++)) > 0) {
        }
        return ctClassArray;
    }

    public static boolean eqParamTypes(String desc1, String desc2) {
        if (desc1.charAt(0) != '(') {
            return false;
        }
        int n2 = 0;
        char c2;
        while ((c2 = desc1.charAt(n2)) == desc2.charAt(n2)) {
            if (c2 == ')') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getParamDescriptor(String decl) {
        return decl.substring(0, decl.indexOf(41) + 1);
    }

    public static CtClass getReturnType(String desc, ClassPool cp) throws NotFoundException {
        int n2 = desc.indexOf(41);
        if (n2 < 0) {
            return null;
        }
        CtClass[] ctClassArray = new CtClass[1];
        Descriptor.toCtClass(cp, desc, n2 + 1, ctClassArray, 0);
        return ctClassArray[0];
    }

    public static int numOfParameters(String desc) {
        char c2;
        int n2 = 0;
        int n3 = 1;
        while ((c2 = desc.charAt(n3)) != ')') {
            while (c2 == '[') {
                c2 = desc.charAt(++n3);
            }
            if (c2 == 'L') {
                if ((n3 = desc.indexOf(59, n3) + 1) <= 0) {
                    throw new IndexOutOfBoundsException("bad descriptor");
                }
            } else {
                ++n3;
            }
            ++n2;
        }
        return n2;
    }

    public static CtClass toCtClass(String desc, ClassPool cp) throws NotFoundException {
        CtClass[] ctClassArray = new CtClass[1];
        int n2 = Descriptor.toCtClass(cp, desc, 0, ctClassArray, 0);
        if (n2 >= 0) {
            return ctClassArray[0];
        }
        return cp.get(desc.replace('/', '.'));
    }

    private static int toCtClass(ClassPool cp, String desc, int i2, CtClass[] args, int n2) throws NotFoundException {
        Object object;
        String string;
        int n3;
        int n4 = 0;
        char c2 = desc.charAt(i2);
        while (c2 == '[') {
            ++n4;
            c2 = desc.charAt(++i2);
        }
        if (c2 == 'L') {
            n3 = desc.indexOf(59, ++i2);
            string = desc.substring(i2, n3++).replace('/', '.');
        } else {
            object = Descriptor.toPrimitiveClass(c2);
            if (object == null) {
                return -1;
            }
            n3 = i2 + 1;
            if (n4 == 0) {
                args[n2] = object;
                return n3;
            }
            string = ((CtClass)object).getName();
        }
        if (n4 > 0) {
            object = new StringBuffer(string);
            while (n4-- > 0) {
                ((StringBuffer)object).append("[]");
            }
            string = ((StringBuffer)object).toString();
        }
        args[n2] = cp.get(string);
        return n3;
    }

    static CtClass toPrimitiveClass(char c2) {
        CtClass ctClass = null;
        switch (c2) {
            case 'Z': {
                ctClass = CtClass.booleanType;
                break;
            }
            case 'C': {
                ctClass = CtClass.charType;
                break;
            }
            case 'B': {
                ctClass = CtClass.byteType;
                break;
            }
            case 'S': {
                ctClass = CtClass.shortType;
                break;
            }
            case 'I': {
                ctClass = CtClass.intType;
                break;
            }
            case 'J': {
                ctClass = CtClass.longType;
                break;
            }
            case 'F': {
                ctClass = CtClass.floatType;
                break;
            }
            case 'D': {
                ctClass = CtClass.doubleType;
                break;
            }
            case 'V': {
                ctClass = CtClass.voidType;
            }
        }
        return ctClass;
    }

    public static int arrayDimension(String desc) {
        int n2 = 0;
        while (desc.charAt(n2) == '[') {
            ++n2;
        }
        return n2;
    }

    public static String toArrayComponent(String desc, int dim) {
        return desc.substring(dim);
    }

    public static int dataSize(String desc) {
        return Descriptor.dataSize(desc, true);
    }

    public static int paramSize(String desc) {
        return -Descriptor.dataSize(desc, false);
    }

    private static int dataSize(String desc, boolean withRet) {
        int n2 = 0;
        char c2 = desc.charAt(0);
        if (c2 == '(') {
            int n3 = 1;
            while (true) {
                if ((c2 = desc.charAt(n3)) == ')') {
                    c2 = desc.charAt(n3 + 1);
                    break;
                }
                boolean bl = false;
                while (c2 == '[') {
                    bl = true;
                    c2 = desc.charAt(++n3);
                }
                if (c2 == 'L') {
                    if ((n3 = desc.indexOf(59, n3) + 1) <= 0) {
                        throw new IndexOutOfBoundsException("bad descriptor");
                    }
                } else {
                    ++n3;
                }
                if (!(bl || c2 != 'J' && c2 != 'D')) {
                    n2 -= 2;
                    continue;
                }
                --n2;
            }
        }
        if (withRet) {
            if (c2 == 'J' || c2 == 'D') {
                n2 += 2;
            } else if (c2 != 'V') {
                ++n2;
            }
        }
        return n2;
    }

    public static String toString(String desc) {
        return PrettyPrinter.toString(desc);
    }

    public static class Iterator {
        private String desc;
        private int index;
        private int curPos;
        private boolean param;

        public Iterator(String s2) {
            this.desc = s2;
            Iterator iterator = this;
            iterator.curPos = 0;
            iterator.index = 0;
            this.param = false;
        }

        public boolean hasNext() {
            return this.index < this.desc.length();
        }

        public boolean isParameter() {
            return this.param;
        }

        public char currentChar() {
            return this.desc.charAt(this.curPos);
        }

        public boolean is2byte() {
            char c2 = this.currentChar();
            return c2 == 'D' || c2 == 'J';
        }

        public int next() {
            int n2;
            char c2;
            if ((c2 = this.desc.charAt(n2 = this.index++)) == '(') {
                c2 = this.desc.charAt(++n2);
                this.param = true;
            }
            if (c2 == ')') {
                ++this.index;
                c2 = this.desc.charAt(++n2);
                this.param = false;
            }
            while (c2 == '[') {
                c2 = this.desc.charAt(++n2);
            }
            if (c2 == 'L') {
                if ((n2 = this.desc.indexOf(59, n2) + 1) <= 0) {
                    throw new IndexOutOfBoundsException("bad descriptor");
                }
            } else {
                ++n2;
            }
            this.curPos = this.index;
            this.index = n2;
            return this.curPos;
        }
    }

    static class PrettyPrinter {
        PrettyPrinter() {
        }

        static String toString(String desc) {
            StringBuffer stringBuffer = new StringBuffer();
            if (desc.charAt(0) == '(') {
                int n2 = 1;
                stringBuffer.append('(');
                while (desc.charAt(n2) != ')') {
                    if (n2 > 1) {
                        stringBuffer.append(',');
                    }
                    n2 = PrettyPrinter.readType(stringBuffer, n2, desc);
                }
                stringBuffer.append(')');
            } else {
                PrettyPrinter.readType(stringBuffer, 0, desc);
            }
            return stringBuffer.toString();
        }

        static int readType(StringBuffer sbuf, int pos, String desc) {
            char c2 = desc.charAt(pos);
            int n2 = 0;
            while (c2 == '[') {
                ++n2;
                c2 = desc.charAt(++pos);
            }
            if (c2 == 'L') {
                while ((c2 = desc.charAt(++pos)) != ';') {
                    if (c2 == '/') {
                        c2 = '.';
                    }
                    sbuf.append(c2);
                }
            } else {
                CtClass ctClass = Descriptor.toPrimitiveClass(c2);
                sbuf.append(ctClass.getName());
            }
            while (n2-- > 0) {
                sbuf.append("[]");
            }
            return pos + 1;
        }
    }
}

