/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class ExceptionsAttribute
extends AttributeInfo {
    public static final String tag = "Exceptions";

    ExceptionsAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super(cp, n2, in);
    }

    private ExceptionsAttribute(ConstPool cp, ExceptionsAttribute src, Map<String, String> classnames) {
        super(cp, tag);
        this.copyFrom(src, classnames);
    }

    public ExceptionsAttribute(ConstPool cp) {
        super(cp, tag);
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray2[1] = 0;
        byArray[0] = 0;
        this.info = byArray2;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        return new ExceptionsAttribute(newCp, this, classnames);
    }

    private void copyFrom(ExceptionsAttribute srcAttr, Map<String, String> classnames) {
        ConstPool constPool = srcAttr.constPool;
        ConstPool constPool2 = this.constPool;
        byte[] byArray = srcAttr.info;
        int n2 = srcAttr.info.length;
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = byArray2;
        byArray2[0] = byArray[0];
        byArray3[1] = byArray[1];
        for (int i2 = 2; i2 < n2; i2 += 2) {
            int n3 = ByteArray.readU16bit(byArray, i2);
            ByteArray.write16bit(constPool.copy(n3, constPool2, classnames), byArray3, i2);
        }
        this.info = byArray3;
    }

    public int[] getExceptionIndexes() {
        byte[] byArray = this.info;
        int n2 = this.info.length;
        if (n2 <= 2) {
            return null;
        }
        int[] nArray = new int[n2 / 2 - 1];
        int n3 = 0;
        for (int i2 = 2; i2 < n2; i2 += 2) {
            nArray[n3++] = (byArray[i2] & 0xFF) << 8 | byArray[i2 + 1] & 0xFF;
        }
        return nArray;
    }

    public String[] getExceptions() {
        byte[] byArray = this.info;
        int n2 = this.info.length;
        if (n2 <= 2) {
            return null;
        }
        String[] stringArray = new String[n2 / 2 - 1];
        int n3 = 0;
        for (int i2 = 2; i2 < n2; i2 += 2) {
            int n4 = (byArray[i2] & 0xFF) << 8 | byArray[i2 + 1] & 0xFF;
            stringArray[n3++] = this.constPool.getClassInfo(n4);
        }
        return stringArray;
    }

    public void setExceptionIndexes(int[] elist) {
        int n2 = elist.length;
        byte[] byArray = new byte[(n2 << 1) + 2];
        ByteArray.write16bit(n2, byArray, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteArray.write16bit(elist[i2], byArray, (i2 << 1) + 2);
        }
        this.info = byArray;
    }

    public void setExceptions(String[] elist) {
        int n2 = elist.length;
        byte[] byArray = new byte[(n2 << 1) + 2];
        ByteArray.write16bit(n2, byArray, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteArray.write16bit(this.constPool.addClassInfo(elist[i2]), byArray, (i2 << 1) + 2);
        }
        this.info = byArray;
    }

    public int tableLength() {
        return this.info.length / 2 - 1;
    }

    public int getException(int nth) {
        int n2 = (nth << 1) + 2;
        return (this.info[n2] & 0xFF) << 8 | this.info[n2 + 1] & 0xFF;
    }
}

