/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.Mnemonic;
import ai.h2o.javassist.bytecode.Opcode;
import java.io.PrintStream;

public class InstructionPrinter
implements Opcode {
    private static final String[] opcodes = Mnemonic.OPCODE;
    private final PrintStream stream;

    public InstructionPrinter(PrintStream stream) {
        this.stream = stream;
    }

    public static void print(CtMethod method, PrintStream stream) {
        new InstructionPrinter(stream).print(method);
    }

    public void print(CtMethod method) {
        MethodInfo methodInfo = method.getMethodInfo2();
        ConstPool constPool = methodInfo.getConstPool();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return;
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        while (codeIterator.hasNext()) {
            int n2;
            try {
                n2 = codeIterator.next();
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException(badBytecode);
            }
            this.stream.println(n2 + ": " + InstructionPrinter.instructionString(codeIterator, n2, constPool));
        }
    }

    public static String instructionString(CodeIterator iter, int pos, ConstPool pool) {
        int n2 = iter.byteAt(pos);
        if (n2 > opcodes.length || n2 < 0) {
            throw new IllegalArgumentException("Invalid opcode, opcode: " + n2 + " pos: " + pos);
        }
        String string = opcodes[n2];
        switch (n2) {
            case 16: {
                return string + " " + iter.byteAt(pos + 1);
            }
            case 17: {
                return string + " " + iter.s16bitAt(pos + 1);
            }
            case 18: {
                return string + " " + InstructionPrinter.ldc(pool, iter.byteAt(pos + 1));
            }
            case 19: 
            case 20: {
                return string + " " + InstructionPrinter.ldc(pool, iter.u16bitAt(pos + 1));
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return string + " " + iter.byteAt(pos + 1);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return string + " " + (iter.s16bitAt(pos + 1) + pos);
            }
            case 132: {
                return string + " " + iter.byteAt(pos + 1) + ", " + iter.signedByteAt(pos + 2);
            }
            case 167: 
            case 168: {
                return string + " " + (iter.s16bitAt(pos + 1) + pos);
            }
            case 169: {
                return string + " " + iter.byteAt(pos + 1);
            }
            case 170: {
                return InstructionPrinter.tableSwitch(iter, pos);
            }
            case 171: {
                return InstructionPrinter.lookupSwitch(iter, pos);
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                return string + " " + InstructionPrinter.fieldInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 182: 
            case 183: 
            case 184: {
                return string + " " + InstructionPrinter.methodInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 185: {
                return string + " " + InstructionPrinter.interfaceMethodInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 186: {
                return string + " " + iter.u16bitAt(pos + 1);
            }
            case 187: {
                return string + " " + InstructionPrinter.classInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 188: {
                return string + " " + InstructionPrinter.arrayInfo(iter.byteAt(pos + 1));
            }
            case 189: 
            case 192: {
                return string + " " + InstructionPrinter.classInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 196: {
                return InstructionPrinter.wide(iter, pos);
            }
            case 197: {
                return string + " " + InstructionPrinter.classInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 200: 
            case 201: {
                return string + " " + (iter.s32bitAt(pos + 1) + pos);
            }
        }
        return string;
    }

    private static String wide(CodeIterator iter, int pos) {
        int n2 = iter.byteAt(pos + 1);
        int n3 = iter.u16bitAt(pos + 2);
        switch (n2) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: {
                return opcodes[n2] + " " + n3;
            }
        }
        throw new RuntimeException("Invalid WIDE operand");
    }

    private static String arrayInfo(int type) {
        switch (type) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
        }
        throw new RuntimeException("Invalid array type");
    }

    private static String classInfo(ConstPool pool, int index) {
        return "#" + index + " = Class " + pool.getClassInfo(index);
    }

    private static String interfaceMethodInfo(ConstPool pool, int index) {
        return "#" + index + " = Method " + pool.getInterfaceMethodrefClassName(index) + "." + pool.getInterfaceMethodrefName(index) + "(" + pool.getInterfaceMethodrefType(index) + ")";
    }

    private static String methodInfo(ConstPool pool, int index) {
        return "#" + index + " = Method " + pool.getMethodrefClassName(index) + "." + pool.getMethodrefName(index) + "(" + pool.getMethodrefType(index) + ")";
    }

    private static String fieldInfo(ConstPool pool, int index) {
        return "#" + index + " = Field " + pool.getFieldrefClassName(index) + "." + pool.getFieldrefName(index) + "(" + pool.getFieldrefType(index) + ")";
    }

    private static String lookupSwitch(CodeIterator iter, int pos) {
        StringBuffer stringBuffer = new StringBuffer("lookupswitch {\n");
        int n2 = (pos & 0xFFFFFFFC) + 4;
        stringBuffer.append("\t\tdefault: ").append(pos + iter.s32bitAt(n2)).append("\n");
        int n3 = iter.s32bitAt(n2 += 4);
        int n4 = (n3 << 3) + (n2 += 4);
        while (n2 < n4) {
            int n5 = iter.s32bitAt(n2);
            int n6 = iter.s32bitAt(n2 + 4) + pos;
            stringBuffer.append("\t\t").append(n5).append(": ").append(n6).append("\n");
            n2 += 8;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer2.setCharAt(stringBuffer2.length() - 1, '}');
        return stringBuffer.toString();
    }

    private static String tableSwitch(CodeIterator iter, int pos) {
        StringBuffer stringBuffer = new StringBuffer("tableswitch {\n");
        int n2 = (pos & 0xFFFFFFFC) + 4;
        stringBuffer.append("\t\tdefault: ").append(pos + iter.s32bitAt(n2)).append("\n");
        int n3 = iter.s32bitAt(n2 += 4);
        int n4 = iter.s32bitAt(n2 += 4);
        int n5 = (n4 - n3 + 1 << 2) + (n2 += 4);
        int n6 = n3;
        while (n2 < n5) {
            int n7 = iter.s32bitAt(n2) + pos;
            stringBuffer.append("\t\t").append(n6).append(": ").append(n7).append("\n");
            n2 += 4;
            ++n6;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer2.setCharAt(stringBuffer2.length() - 1, '}');
        return stringBuffer.toString();
    }

    private static String ldc(ConstPool pool, int index) {
        int n2 = pool.getTag(index);
        switch (n2) {
            case 8: {
                return "#" + index + " = \"" + pool.getStringInfo(index) + "\"";
            }
            case 3: {
                return "#" + index + " = int " + pool.getIntegerInfo(index);
            }
            case 4: {
                return "#" + index + " = float " + pool.getFloatInfo(index);
            }
            case 5: {
                return "#" + index + " = long " + pool.getLongInfo(index);
            }
            case 6: {
                return "#" + index + " = int " + pool.getDoubleInfo(index);
            }
            case 7: {
                return InstructionPrinter.classInfo(pool, index);
            }
        }
        throw new RuntimeException("bad LDC: " + n2);
    }
}

