/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.ConstInfo;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

class MethodTypeInfo
extends ConstInfo {
    static final int tag = 16;
    int descriptor;

    public MethodTypeInfo(int desc, int index) {
        super(index);
        this.descriptor = desc;
    }

    public MethodTypeInfo(DataInputStream in, int index) throws IOException {
        super(index);
        this.descriptor = in.readUnsignedShort();
    }

    public int hashCode() {
        return this.descriptor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodTypeInfo) {
            return ((MethodTypeInfo)obj).descriptor == this.descriptor;
        }
        return false;
    }

    @Override
    public int getTag() {
        return 16;
    }

    @Override
    public void renameClass(ConstPool cp, String oldName, String newName, Map<ConstInfo, ConstInfo> cache) {
        String string;
        String string2 = cp.getUtf8Info(this.descriptor);
        if (string2 != (string = Descriptor.rename(string2, oldName, newName))) {
            if (cache == null) {
                this.descriptor = cp.addUtf8Info(string);
                return;
            }
            cache.remove(this);
            this.descriptor = cp.addUtf8Info(string);
            MethodTypeInfo methodTypeInfo = this;
            cache.put(methodTypeInfo, methodTypeInfo);
        }
    }

    @Override
    public void renameClass(ConstPool cp, Map<String, String> map, Map<ConstInfo, ConstInfo> cache) {
        String string;
        String string2 = cp.getUtf8Info(this.descriptor);
        if (string2 != (string = Descriptor.rename(string2, map))) {
            if (cache == null) {
                this.descriptor = cp.addUtf8Info(string);
                return;
            }
            cache.remove(this);
            this.descriptor = cp.addUtf8Info(string);
            MethodTypeInfo methodTypeInfo = this;
            cache.put(methodTypeInfo, methodTypeInfo);
        }
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<String, String> map) {
        String string = src.getUtf8Info(this.descriptor);
        string = Descriptor.rename(string, map);
        ConstPool constPool = dest;
        return constPool.addMethodTypeInfo(constPool.addUtf8Info(string));
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(16);
        out.writeShort(this.descriptor);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("MethodType #");
        out.println(this.descriptor);
    }
}

