/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.bytecode.analysis.Subroutine;
import ai.h2o.javassist.bytecode.analysis.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SubroutineScanner
implements Opcode {
    private Subroutine[] subroutines;
    Map<Integer, Subroutine> subTable = new HashMap<Integer, Subroutine>();
    Set<Integer> done = new HashSet<Integer>();

    public Subroutine[] scan(MethodInfo method) throws BadBytecode {
        CodeAttribute codeAttribute = method.getCodeAttribute();
        CodeIterator codeIterator = codeAttribute.iterator();
        this.subroutines = new Subroutine[codeAttribute.getCodeLength()];
        this.subTable.clear();
        this.done.clear();
        this.scan(0, codeIterator, null);
        ExceptionTable exceptionTable = codeAttribute.getExceptionTable();
        for (int i2 = 0; i2 < exceptionTable.size(); ++i2) {
            int n2 = exceptionTable.handlerPc(i2);
            this.scan(n2, codeIterator, this.subroutines[exceptionTable.startPc(i2)]);
        }
        return this.subroutines;
    }

    private void scan(int pos, CodeIterator iter, Subroutine sub) throws BadBytecode {
        boolean bl;
        if (this.done.contains(pos)) {
            return;
        }
        this.done.add(pos);
        int n2 = iter.lookAhead();
        iter.move(pos);
        while (bl = this.scanOp(pos = iter.next(), iter, sub) && iter.hasNext()) {
        }
        iter.move(n2);
    }

    private boolean scanOp(int pos, CodeIterator iter, Subroutine sub) throws BadBytecode {
        this.subroutines[pos] = sub;
        int n2 = iter.byteAt(pos);
        if (n2 == 170) {
            this.scanTableSwitch(pos, iter, sub);
            return false;
        }
        if (n2 == 171) {
            this.scanLookupSwitch(pos, iter, sub);
            return false;
        }
        if (Util.isReturn(n2) || n2 == 169 || n2 == 191) {
            return false;
        }
        if (Util.isJumpInstruction(n2)) {
            int n3 = Util.getJumpTarget(pos, iter);
            if (n2 == 168 || n2 == 201) {
                Subroutine subroutine = this.subTable.get(n3);
                if (subroutine == null) {
                    subroutine = new Subroutine(n3, pos);
                    this.subTable.put(n3, subroutine);
                    this.scan(n3, iter, subroutine);
                } else {
                    subroutine.addCaller(pos);
                }
            } else {
                this.scan(n3, iter, sub);
                if (Util.isGoto(n2)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void scanLookupSwitch(int pos, CodeIterator iter, Subroutine sub) throws BadBytecode {
        int n2 = (pos & 0xFFFFFFFC) + 4;
        this.scan(pos + iter.s32bitAt(n2), iter, sub);
        int n3 = iter.s32bitAt(n2 += 4);
        int n4 = (n3 << 3) + (n2 += 4);
        n2 += 4;
        while (n2 < n4) {
            int n5 = iter.s32bitAt(n2) + pos;
            this.scan(n5, iter, sub);
            n2 += 8;
        }
    }

    private void scanTableSwitch(int pos, CodeIterator iter, Subroutine sub) throws BadBytecode {
        int n2 = (pos & 0xFFFFFFFC) + 4;
        this.scan(pos + iter.s32bitAt(n2), iter, sub);
        int n3 = iter.s32bitAt(n2 += 4);
        int n4 = iter.s32bitAt(n2 += 4);
        int n5 = (n4 - n3 + 1 << 2) + (n2 += 4);
        while (n2 < n5) {
            int n6 = iter.s32bitAt(n2) + pos;
            this.scan(n6, iter, sub);
            n2 += 4;
        }
    }
}

