/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.expr;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtBehavior;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtPrimitiveType;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.ExceptionsAttribute;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.expr.ExprEditor;
import java.util.LinkedList;
import java.util.List;

public abstract class Expr
implements Opcode {
    int currentPos;
    CodeIterator iterator;
    CtClass thisClass;
    MethodInfo thisMethod;
    boolean edited;
    int maxLocals;
    int maxStack;
    static final String javaLangObject = "java.lang.Object";

    protected Expr(int pos, CodeIterator i2, CtClass declaring, MethodInfo m2) {
        this.currentPos = pos;
        this.iterator = i2;
        this.thisClass = declaring;
        this.thisMethod = m2;
    }

    public CtClass getEnclosingClass() {
        return this.thisClass;
    }

    protected final ConstPool getConstPool() {
        return this.thisMethod.getConstPool();
    }

    protected final boolean edited() {
        return this.edited;
    }

    protected final int locals() {
        return this.maxLocals;
    }

    protected final int stack() {
        return this.maxStack;
    }

    protected final boolean withinStatic() {
        return (this.thisMethod.getAccessFlags() & 8) != 0;
    }

    public CtBehavior where() {
        MethodInfo methodInfo = this.thisMethod;
        CtBehavior[] ctBehaviorArray = this.thisClass.getDeclaredBehaviors();
        for (int i2 = ctBehaviorArray.length - 1; i2 >= 0; --i2) {
            if (ctBehaviorArray[i2].getMethodInfo2() != methodInfo) continue;
            return ctBehaviorArray[i2];
        }
        CtConstructor ctConstructor = this.thisClass.getClassInitializer();
        if (ctConstructor != null && ctConstructor.getMethodInfo2() == methodInfo) {
            return ctConstructor;
        }
        for (int i3 = ctBehaviorArray.length - 1; i3 >= 0; --i3) {
            if (!this.thisMethod.getName().equals(ctBehaviorArray[i3].getMethodInfo2().getName()) || !this.thisMethod.getDescriptor().equals(ctBehaviorArray[i3].getMethodInfo2().getDescriptor())) continue;
            return ctBehaviorArray[i3];
        }
        throw new RuntimeException("fatal: not found");
    }

    public CtClass[] mayThrow() {
        int n2;
        int n3;
        String[] stringArray;
        AttributeInfo attributeInfo;
        ClassPool classPool = this.thisClass.getClassPool();
        ConstPool constPool = this.thisMethod.getConstPool();
        LinkedList<CtClass> linkedList = new LinkedList<CtClass>();
        try {
            attributeInfo = this.thisMethod.getCodeAttribute();
            stringArray = ((CodeAttribute)attributeInfo).getExceptionTable();
            n3 = this.currentPos;
            n2 = stringArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4;
                if (stringArray.startPc(i2) > n3 || n3 >= stringArray.endPc(i2) || (n4 = stringArray.catchType(i2)) <= 0) continue;
                try {
                    Expr.addClass(linkedList, classPool.get(constPool.getClassInfo(n4)));
                    continue;
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        catch (NullPointerException nullPointerException) {}
        if ((attributeInfo = this.thisMethod.getExceptionsAttribute()) != null && (stringArray = ((ExceptionsAttribute)attributeInfo).getExceptions()) != null) {
            n3 = stringArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    Expr.addClass(linkedList, classPool.get(stringArray[n2]));
                    continue;
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        LinkedList<CtClass> linkedList2 = linkedList;
        return linkedList2.toArray(new CtClass[linkedList2.size()]);
    }

    private static void addClass(List<CtClass> list, CtClass c2) {
        if (list.contains(c2)) {
            return;
        }
        list.add(c2);
    }

    public int indexOfBytecode() {
        return this.currentPos;
    }

    public int getLineNumber() {
        return this.thisMethod.getLineNumber(this.currentPos);
    }

    public String getFileName() {
        ClassFile classFile = this.thisClass.getClassFile2();
        if (classFile == null) {
            return null;
        }
        return classFile.getSourceFile();
    }

    static final boolean checkResultValue(CtClass retType, String prog) throws CannotCompileException {
        boolean bl = prog.indexOf("$_") >= 0;
        if (!bl && retType != CtClass.voidType) {
            throw new CannotCompileException("the resulting value is not stored in $_");
        }
        return bl;
    }

    static final void storeStack(CtClass[] params, boolean isStaticCall, int regno, Bytecode bytecode) {
        Expr.storeStack0(0, params.length, params, regno + 1, bytecode);
        if (isStaticCall) {
            bytecode.addOpcode(1);
        }
        bytecode.addAstore(regno);
    }

    private static void storeStack0(int i2, int n2, CtClass[] params, int regno, Bytecode bytecode) {
        if (i2 >= n2) {
            return;
        }
        CtClass ctClass = params[i2];
        int n3 = ctClass instanceof CtPrimitiveType ? ((CtPrimitiveType)ctClass).getDataSize() : 1;
        Expr.storeStack0(i2 + 1, n2, params, regno + n3, bytecode);
        bytecode.addStore(regno, ctClass);
    }

    public abstract void replace(String var1) throws CannotCompileException;

    public void replace(String statement, ExprEditor recursive) throws CannotCompileException {
        this.replace(statement);
        if (recursive != null) {
            this.runEditor(recursive, this.iterator);
        }
    }

    protected void replace0(int pos, Bytecode bytecode, int size) throws BadBytecode {
        byte[] byArray = bytecode.get();
        this.edited = true;
        int n2 = byArray.length - size;
        for (int i2 = 0; i2 < size; ++i2) {
            this.iterator.writeByte(0, pos + i2);
        }
        if (n2 > 0) {
            pos = this.iterator.insertGapAt((int)pos, (int)n2, (boolean)false).position;
        }
        this.iterator.write(byArray, pos);
        this.iterator.insert(bytecode.getExceptionTable(), pos);
        this.maxLocals = bytecode.getMaxLocals();
        this.maxStack = bytecode.getMaxStack();
    }

    protected void runEditor(ExprEditor ed, CodeIterator oldIterator) throws CannotCompileException {
        CodeAttribute codeAttribute = oldIterator.get();
        int n2 = codeAttribute.getMaxLocals();
        int n3 = codeAttribute.getMaxStack();
        int n4 = this.locals();
        codeAttribute.setMaxStack(this.stack());
        codeAttribute.setMaxLocals(n4);
        ExprEditor.LoopContext loopContext = new ExprEditor.LoopContext(n4);
        int n5 = oldIterator.getCodeLength();
        int n6 = oldIterator.lookAhead();
        oldIterator.move(this.currentPos);
        if (ed.doit(this.thisClass, this.thisMethod, loopContext, oldIterator, n6)) {
            this.edited = true;
        }
        oldIterator.move(n6 + oldIterator.getCodeLength() - n5);
        codeAttribute.setMaxLocals(n2);
        codeAttribute.setMaxStack(n3);
        this.maxLocals = loopContext.maxLocals;
        this.maxStack += loopContext.maxStack;
    }
}

