/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.expr;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.CtBehavior;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtPrimitiveType;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;
import ai.h2o.javassist.compiler.JvstCodeGen;
import ai.h2o.javassist.compiler.JvstTypeChecker;
import ai.h2o.javassist.compiler.ProceedHandler;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.expr.Expr;

public class NewArray
extends Expr {
    int opcode;

    protected NewArray(int pos, CodeIterator i2, CtClass declaring, MethodInfo m2, int op) {
        super(pos, i2, declaring, m2);
        this.opcode = op;
    }

    @Override
    public CtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    @Override
    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    public CtClass getComponentType() throws NotFoundException {
        if (this.opcode == 188) {
            int n2 = this.iterator.byteAt(this.currentPos + 1);
            return this.getPrimitiveType(n2);
        }
        if (this.opcode == 189 || this.opcode == 197) {
            int n3 = this.iterator.u16bitAt(this.currentPos + 1);
            String string = this.getConstPool().getClassInfo(n3);
            int n4 = Descriptor.arrayDimension(string);
            string = Descriptor.toArrayComponent(string, n4);
            return Descriptor.toCtClass(string, this.thisClass.getClassPool());
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    CtClass getPrimitiveType(int atype) {
        switch (atype) {
            case 4: {
                return CtClass.booleanType;
            }
            case 5: {
                return CtClass.charType;
            }
            case 6: {
                return CtClass.floatType;
            }
            case 7: {
                return CtClass.doubleType;
            }
            case 8: {
                return CtClass.byteType;
            }
            case 9: {
                return CtClass.shortType;
            }
            case 10: {
                return CtClass.intType;
            }
            case 11: {
                return CtClass.longType;
            }
        }
        throw new RuntimeException("bad atype: " + atype);
    }

    public int getDimension() {
        if (this.opcode == 188) {
            return 1;
        }
        if (this.opcode == 189 || this.opcode == 197) {
            int n2 = this.iterator.u16bitAt(this.currentPos + 1);
            String string = this.getConstPool().getClassInfo(n2);
            return Descriptor.arrayDimension(string) + (this.opcode == 189 ? 1 : 0);
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    public int getCreatedDimensions() {
        if (this.opcode == 197) {
            return this.iterator.byteAt(this.currentPos + 3);
        }
        return 1;
    }

    @Override
    public void replace(String statement) throws CannotCompileException {
        try {
            this.replace2(statement);
            return;
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException("broken method");
        }
    }

    private void replace2(String statement) throws CompileError, NotFoundException, BadBytecode, CannotCompileException {
        int n2;
        int n3;
        String string;
        Object object;
        int n4;
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int n5 = this.currentPos;
        int n6 = 1;
        if (this.opcode == 188) {
            n4 = this.iterator.byteAt(this.currentPos + 1);
            object = (CtPrimitiveType)this.getPrimitiveType(n4);
            string = "[" + ((CtPrimitiveType)object).getDescriptor();
            n3 = 2;
        } else if (this.opcode == 189) {
            n4 = this.iterator.u16bitAt(n5 + 1);
            string = constPool.getClassInfo(n4);
            string = string.startsWith("[") ? "[" + string : "[L" + string + ";";
            n3 = 3;
        } else if (this.opcode == 197) {
            n4 = this.iterator.u16bitAt(this.currentPos + 1);
            string = constPool.getClassInfo(n4);
            n6 = this.iterator.byteAt(this.currentPos + 3);
            n3 = 4;
        } else {
            throw new RuntimeException("bad opcode: " + this.opcode);
        }
        CtClass ctClass = Descriptor.toCtClass(string, this.thisClass.getClassPool());
        object = new Javac(this.thisClass);
        CodeAttribute codeAttribute = this.iterator.get();
        CtClass[] ctClassArray = new CtClass[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            ctClassArray[n2] = CtClass.intType;
        }
        n2 = codeAttribute.getMaxLocals();
        ((Javac)object).recordParams("java.lang.Object", ctClassArray, true, n2, this.withinStatic());
        NewArray.checkResultValue(ctClass, statement);
        int n7 = ((Javac)object).recordReturnType(ctClass, true);
        ((Javac)object).recordProceed(new ProceedForArray(ctClass, this.opcode, n4, n6));
        Bytecode bytecode = ((Javac)object).getBytecode();
        NewArray.storeStack(ctClassArray, true, n2, bytecode);
        ((Javac)object).recordLocalVariables(codeAttribute, n5);
        bytecode.addOpcode(1);
        bytecode.addAstore(n7);
        ((Javac)object).compileStmnt(statement);
        bytecode.addAload(n7);
        this.replace0(n5, bytecode, n3);
    }

    static class ProceedForArray
    implements ProceedHandler {
        CtClass arrayType;
        int opcode;
        int index;
        int dimension;

        ProceedForArray(CtClass type, int op, int i2, int dim) {
            this.arrayType = type;
            this.opcode = op;
            this.index = i2;
            this.dimension = dim;
        }

        @Override
        public void doit(JvstCodeGen gen, Bytecode bytecode, ASTList args) throws CompileError {
            int n2 = gen.getMethodArgsLength(args);
            if (n2 != this.dimension) {
                throw new CompileError("$proceed() with a wrong number of parameters");
            }
            gen.atMethodArgs(args, new int[n2], new int[n2], new String[n2]);
            bytecode.addOpcode(this.opcode);
            if (this.opcode == 189) {
                bytecode.addIndex(this.index);
            } else if (this.opcode == 188) {
                bytecode.add(this.index);
            } else {
                bytecode.addIndex(this.index);
                bytecode.add(this.dimension);
                bytecode.growStack(1 - this.dimension);
            }
            gen.setType(this.arrayType);
        }

        @Override
        public void setReturnType(JvstTypeChecker c2, ASTList args) throws CompileError {
            c2.setType(this.arrayType);
        }
    }
}

