/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.scopedpool;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SoftValueHashMap<K, V>
implements Map<K, V> {
    private Map<K, SoftValueRef<K, V>> hash;
    private ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, SoftValueRef<K, V>> entry : this.hash.entrySet()) {
            hashSet.add(new AbstractMap.SimpleImmutableEntry(entry.getKey(), entry.getValue().get()));
        }
        return hashSet;
    }

    private void processQueue() {
        if (!this.hash.isEmpty()) {
            Reference<V> reference;
            while ((reference = this.queue.poll()) != null) {
                if (!(reference instanceof SoftValueRef)) continue;
                SoftValueRef softValueRef = (SoftValueRef)reference;
                if (reference != this.hash.get(softValueRef.key)) continue;
                this.hash.remove(softValueRef.key);
            }
        }
    }

    public SoftValueHashMap(int initialCapacity, float loadFactor) {
        this.hash = new ConcurrentHashMap<K, SoftValueRef<K, V>>(initialCapacity, loadFactor);
    }

    public SoftValueHashMap(int initialCapacity) {
        this.hash = new ConcurrentHashMap<K, SoftValueRef<K, V>>(initialCapacity);
    }

    public SoftValueHashMap() {
        this.hash = new ConcurrentHashMap<K, SoftValueRef<K, V>>();
    }

    public SoftValueHashMap(Map<K, V> t2) {
        this(Math.max(2 * t2.size(), 11), 0.75f);
        this.putAll(t2);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.hash.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.hash.containsKey(key);
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        SoftValueHashMap softValueHashMap = this;
        return softValueHashMap.valueOrNull(softValueHashMap.hash.get(key));
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        SoftValueHashMap softValueHashMap = this;
        K k2 = key;
        return softValueHashMap.valueOrNull(softValueHashMap.hash.put(k2, SoftValueRef.create(k2, value, this.queue)));
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        SoftValueHashMap softValueHashMap = this;
        return softValueHashMap.valueOrNull(softValueHashMap.hash.remove(key));
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public boolean containsValue(Object arg0) {
        this.processQueue();
        if (arg0 == null) {
            return false;
        }
        for (SoftValueRef<K, V> softValueRef : this.hash.values()) {
            if (softValueRef == null || !arg0.equals(softValueRef.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.hash.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> arg0) {
        this.processQueue();
        for (K k2 : arg0.keySet()) {
            this.put(k2, arg0.get(k2));
        }
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        ArrayList arrayList = new ArrayList();
        for (SoftValueRef<K, V> softValueRef : this.hash.values()) {
            arrayList.add(softValueRef.get());
        }
        return arrayList;
    }

    private V valueOrNull(SoftValueRef<K, V> rtn) {
        if (rtn == null) {
            return null;
        }
        return (V)rtn.get();
    }

    private static class SoftValueRef<K, V>
    extends SoftReference<V> {
        public K key;

        private SoftValueRef(K key, V val, ReferenceQueue<V> q2) {
            super(val, q2);
            this.key = key;
        }

        private static <K, V> SoftValueRef<K, V> create(K key, V val, ReferenceQueue<V> q2) {
            if (val == null) {
                return null;
            }
            return new SoftValueRef<K, V>(key, val, q2);
        }
    }
}

