/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.util;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.management.ManagementFactory;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public class HotSwapAgent {
    private static Instrumentation instrumentation = null;

    public Instrumentation instrumentation() {
        return instrumentation;
    }

    public static void premain(String agentArgs, Instrumentation inst) throws Throwable {
        HotSwapAgent.agentmain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) throws Throwable {
        if (!inst.isRedefineClassesSupported()) {
            throw new RuntimeException("this JVM does not support redefinition of classes");
        }
        instrumentation = inst;
    }

    public static void redefine(Class<?> oldClass, CtClass newClass) throws NotFoundException, IOException, CannotCompileException {
        Class[] classArray = new Class[]{oldClass};
        CtClass[] ctClassArray = new CtClass[]{newClass};
        HotSwapAgent.redefine(classArray, ctClassArray);
    }

    public static void redefine(Class<?>[] oldClasses, CtClass[] newClasses) throws NotFoundException, IOException, CannotCompileException {
        HotSwapAgent.startAgent();
        ClassDefinition[] classDefinitionArray = new ClassDefinition[oldClasses.length];
        for (int i2 = 0; i2 < oldClasses.length; ++i2) {
            classDefinitionArray[i2] = new ClassDefinition(oldClasses[i2], newClasses[i2].toBytecode());
        }
        try {
            instrumentation.redefineClasses(classDefinitionArray);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NotFoundException(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (UnmodifiableClassException unmodifiableClassException) {
            throw new CannotCompileException(unmodifiableClassException.getMessage(), unmodifiableClassException);
        }
    }

    private static void startAgent() throws NotFoundException {
        if (instrumentation != null) {
            return;
        }
        try {
            File file = HotSwapAgent.createJarFile();
            String string = ManagementFactory.getRuntimeMXBean().getName();
            String string2 = string.substring(0, string.indexOf(64));
            VirtualMachine virtualMachine = VirtualMachine.attach(string2);
            virtualMachine.loadAgent(file.getAbsolutePath(), null);
            virtualMachine.detach();
        }
        catch (Exception exception) {
            throw new NotFoundException("hotswap agent", exception);
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            if (instrumentation != null) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new NotFoundException("hotswap agent (timeout)");
    }

    public static File createAgentJarFile(String fileName) throws IOException, CannotCompileException, NotFoundException {
        return HotSwapAgent.createJarFile(new File(fileName));
    }

    private static File createJarFile() throws IOException, CannotCompileException, NotFoundException {
        File file = File.createTempFile("agent", ".jar");
        file.deleteOnExit();
        return HotSwapAgent.createJarFile(file);
    }

    private static File createJarFile(File jar) throws IOException, CannotCompileException, NotFoundException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("Premain-Class"), HotSwapAgent.class.getName());
        attributes.put(new Attributes.Name("Agent-Class"), HotSwapAgent.class.getName());
        attributes.put(new Attributes.Name("Can-Retransform-Classes"), "true");
        attributes.put(new Attributes.Name("Can-Redefine-Classes"), "true");
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(jar), manifest);
            String string = HotSwapAgent.class.getName();
            JarEntry jarEntry = new JarEntry(string.replace('.', '/') + ".class");
            ((JarOutputStream)zipOutputStream).putNextEntry(jarEntry);
            ClassPool classPool = ClassPool.getDefault();
            CtClass ctClass = classPool.get(string);
            zipOutputStream.write(ctClass.toBytecode());
            zipOutputStream.closeEntry();
        }
        catch (Throwable throwable) {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            throw throwable;
        }
        zipOutputStream.close();
        return jar;
    }
}

