/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoRow;
import ai.h2o.mojos.runtime.frame.StringConverter;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;

public class MojoRowBuilder {
    private final Map<String, Integer> columnNamesMap;
    private final MojoColumn.Type[] columnTypes;
    private final Collection<String> missingValues;
    private final StringConverter[] stringConverters;
    private final boolean strict;
    private Object[] values;
    private boolean[] setValues;

    MojoRowBuilder(Map<String, Integer> columnNamesMap, MojoColumn.Type[] columnTypes, Collection<String> missingValues, StringConverter[] stringConverters, boolean strict) {
        this.columnNamesMap = columnNamesMap;
        this.columnTypes = columnTypes;
        this.missingValues = missingValues;
        this.stringConverters = stringConverters;
        this.strict = strict;
        this.values = new Object[this.columnTypes.length];
        this.setValues = new boolean[this.values.length];
    }

    public MojoRowBuilder setValue(String name, String value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setValue(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setValue(int idx, String value) {
        Object object;
        if (idx < 0 || idx >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("Index " + idx + " is out the scope of this MojoRowBuilder.");
        }
        if (value != null && !this.missingValues.contains(value)) {
            MojoColumn.Type type = this.columnTypes[idx];
            object = this.stringConverters[idx].convert(value, type);
        } else {
            object = null;
        }
        this.values[idx] = object;
        this.setValues[idx] = true;
        return this;
    }

    public MojoRowBuilder setBool(String name, Boolean value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setBool(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setChar(String name, Character value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setChar(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setByte(String name, Byte value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setByte(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setShort(String name, Short value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setShort(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setInt(String name, Integer value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setInt(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setLong(String name, Long value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setLong(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setFloat(String name, Float value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setFloat(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setDouble(String name, Double value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setDouble(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setString(String name, String value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setString(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setDate(String name, Date value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setDate(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    public MojoRowBuilder setTimestamp(String name, Timestamp value) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            this.setTimestamp(n2, value);
        } else if (this.isStrict()) {
            throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
        }
        return this;
    }

    private MojoRowBuilder setJavaValue(int idx, Object value) {
        if (idx < 0 || idx >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("Index " + idx + " is out of the scope of this MojoRowBuilder");
        }
        this.values[idx] = this.columnTypes[idx].fromJavaClass(value);
        this.setValues[idx] = true;
        return this;
    }

    public MojoRowBuilder setBool(int idx, Boolean value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setByte(int idx, Byte value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setShort(int idx, Short value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setChar(int idx, Character value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setInt(int idx, Integer value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setLong(int idx, Long value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setFloat(int idx, Float value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setDouble(int idx, Double value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setString(int idx, String value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setDate(int idx, Date value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setTimestamp(int idx, Timestamp value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setValues(Object[] values) {
        if (values.length != this.values.length) {
            throw new IllegalArgumentException("Length of values argument does not match size of MojoRowBuilder! Expected: " + this.values.length + ", but got: " + values.length);
        }
        System.arraycopy(values, 0, this.values, 0, this.values.length);
        return this;
    }

    MojoRow toMojoRow() {
        if (this.isStrict()) {
            for (int i2 = 0; i2 < this.setValues.length; ++i2) {
                if (this.setValues[i2]) continue;
                String string = "[" + i2;
                for (int i3 = i2 + 1; i3 < this.setValues.length; ++i3) {
                    if (this.setValues[i3]) continue;
                    string = string + ", " + i3;
                }
                string = string + ']';
                throw new IllegalStateException("Columns at indices " + string + " have not been set");
            }
        }
        return new MojoRow(this.values);
    }

    public void clear() {
        this.values = new Object[this.values.length];
        this.setValues = new boolean[this.setValues.length];
    }

    public int size() {
        return this.values.length;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isSet(String name) {
        Integer n2 = this.columnNamesMap.get(name);
        if (n2 != null) {
            return this.isSet(n2);
        }
        throw new IllegalArgumentException("Column \"" + name + "\" does not exist is this MojoRowBuilder");
    }

    public boolean isSet(int idx) {
        if (idx >= 0 && idx < this.size()) {
            return this.setValues[idx];
        }
        throw new ArrayIndexOutOfBoundsException("Index " + idx + " is out of the scope of this MojoRowBuilder");
    }

    public boolean containsName(String name) {
        return this.columnNamesMap.containsKey(name);
    }
}

