/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.frame.MojoColumnFloat64;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.utils.Debug;
import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.AbstractPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;

public class H2O3Transform
extends MojoTransform {
    private final GenModel genModel;
    private final EasyPredictModelWrapper easyPredictModelWrapper;

    H2O3Transform(MojoFrameMeta meta, int[] iindices, int[] oindices, EasyPredictModelWrapper easyPredictModelWrapper) {
        super(meta, iindices, oindices);
        this.easyPredictModelWrapper = easyPredictModelWrapper;
        this.genModel = easyPredictModelWrapper.m;
    }

    @Override
    public void transform(MojoFrame frame) {
        int n2;
        ModelCategory modelCategory = this.genModel.getModelCategory();
        int n3 = this.iindices.length;
        int n4 = frame.getNrows();
        String[][] stringArrayArray = new String[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = this.iindices[n2];
            stringArrayArray[n2] = frame.getColumn(n5).getDataAsStrings();
        }
        block10: for (n2 = 0; n2 < n4; ++n2) {
            Object object;
            RowData rowData = new RowData();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n6 = this.iindices[i2];
                object = frame.getColumnName(n6);
                String string = stringArrayArray[i2][n2];
                if (string == null) continue;
                rowData.put(object, string);
            }
            try {
                switch (modelCategory) {
                    case Binomial: {
                        AbstractPrediction abstractPrediction = this.easyPredictModelWrapper.predictBinomial(rowData);
                        this.setPrediction(frame, n2, abstractPrediction.classProbabilities);
                        continue block10;
                    }
                    case Multinomial: {
                        AbstractPrediction abstractPrediction = this.easyPredictModelWrapper.predictMultinomial(rowData);
                        this.setPrediction(frame, n2, ((MultinomialModelPrediction)abstractPrediction).classProbabilities);
                        continue block10;
                    }
                    case Regression: {
                        AbstractPrediction abstractPrediction = this.easyPredictModelWrapper.predictRegression(rowData);
                        MojoColumnFloat64 mojoColumnFloat64 = (MojoColumnFloat64)frame.getColumn(this.oindices[0]);
                        double[] dArray = (double[])mojoColumnFloat64.getData();
                        object = dArray;
                        dArray[n2] = ((RegressionModelPrediction)abstractPrediction).value;
                        continue block10;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported ModelCategory: " + modelCategory.toString());
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                UnsupportedOperationException unsupportedOperationException2 = unsupportedOperationException;
                throw unsupportedOperationException;
            }
            catch (PredictException predictException) {
                if (Debug.getPrintH2O3Exceptions()) {
                    predictException.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed: %s", new Object[]{modelCategory, predictException.getMessage()}));
            }
            catch (Exception exception) {
                if (Debug.getPrintH2O3Exceptions()) {
                    exception.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed with %s: %s", new Object[]{modelCategory, exception.getClass().getName(), exception.getMessage()}));
            }
        }
    }

    private void setPrediction(MojoFrame frame, int rowIdx, double[] classProbabilities) {
        for (int i2 = 0; i2 < this.oindices.length; ++i2) {
            int n2 = this.oindices[i2];
            MojoColumnFloat64 mojoColumnFloat64 = (MojoColumnFloat64)frame.getColumn(n2);
            double[] dArray = (double[])mojoColumnFloat64.getData();
            double[] dArray2 = dArray;
            dArray[rowIdx] = classProbabilities[i2];
        }
    }
}

