/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCSVToBean {
    private Map<Class<?>, PropertyEditor> editorMap = null;

    protected abstract PropertyEditor getPropertyEditor(PropertyDescriptor var1) throws InstantiationException, IllegalAccessException;

    protected String checkForTrim(String s2, PropertyDescriptor prop) {
        if (s2 != null && this.trimmableProperty(prop)) {
            return s2.trim();
        }
        return s2;
    }

    private boolean trimmableProperty(PropertyDescriptor prop) {
        return !prop.getPropertyType().getName().contains("String");
    }

    protected Object convertValue(String value, PropertyDescriptor prop) throws InstantiationException, IllegalAccessException {
        PropertyEditor propertyEditor = this.getPropertyEditor(prop);
        Object object = value;
        if (propertyEditor != null) {
            propertyEditor.setAsText(value);
            object = propertyEditor.getValue();
        }
        return object;
    }

    protected PropertyEditor getPropertyEditorValue(Class<?> cls) {
        PropertyEditor propertyEditor;
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if ((propertyEditor = this.editorMap.get(cls)) == null) {
            propertyEditor = PropertyEditorManager.findEditor(cls);
            this.addEditorToMap(cls, propertyEditor);
        }
        return propertyEditor;
    }

    private void addEditorToMap(Class<?> cls, PropertyEditor editor) {
        if (editor != null) {
            this.editorMap.put(cls, editor);
        }
    }
}

