/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.exceptions.CsvException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;

public class AccumulateCsvResults<T>
extends Thread {
    private final BlockingQueue<OrderedObject<T>> resultantBeansQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final ConcurrentMap<Long, T> resultantBeanMap;
    private final ConcurrentMap<Long, CsvException> thrownExceptionsMap;
    private boolean mustStop = false;

    public AccumulateCsvResults(BlockingQueue<OrderedObject<T>> resultantBeansQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, ConcurrentMap<Long, T> resultantBeanMap, ConcurrentMap<Long, CsvException> thrownExceptionsMap) {
        this.resultantBeansQueue = resultantBeansQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.resultantBeanMap = resultantBeanMap;
        this.thrownExceptionsMap = thrownExceptionsMap;
    }

    public synchronized boolean isMustStop() {
        return this.mustStop;
    }

    public synchronized void setMustStop(boolean mustStop) {
        this.mustStop = mustStop;
    }

    @Override
    public void run() {
        while (!(this.isMustStop() && this.resultantBeansQueue.isEmpty() && this.thrownExceptionsQueue.isEmpty())) {
            OrderedObject orderedObject;
            while (!this.resultantBeansQueue.isEmpty()) {
                orderedObject = (OrderedObject)this.resultantBeansQueue.poll();
                if (orderedObject == null) continue;
                this.resultantBeanMap.put(orderedObject.getOrdinal(), orderedObject.getElement());
            }
            while (!this.thrownExceptionsQueue.isEmpty()) {
                orderedObject = (OrderedObject)this.thrownExceptionsQueue.poll();
                if (orderedObject == null) continue;
                this.thrownExceptionsMap.put(orderedObject.getOrdinal(), (CsvException)orderedObject.getElement());
            }
            Thread.yield();
        }
    }
}

