/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.stream.reader;

import java.io.BufferedReader;
import java.io.IOException;

public class LineReader {
    private final BufferedReader reader;
    private final boolean keepCarriageReturns;

    public LineReader(BufferedReader reader, boolean keepCarriageReturns) {
        this.reader = reader;
        this.keepCarriageReturns = keepCarriageReturns;
    }

    public String readLine() throws IOException {
        if (this.keepCarriageReturns) {
            return this.readUntilNewline();
        }
        return this.reader.readLine();
    }

    private String readUntilNewline() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(1024);
        int n2 = this.reader.read();
        while (n2 >= 0 && n2 != 10) {
            stringBuilder.append((char)n2);
            n2 = this.reader.read();
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }
}

