/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import com.b.a.m;
import hex.ModelCategory;
import hex.genmodel.ModelMojoFactory;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import hex.genmodel.descriptor.ModelDescriptorBuilder;
import hex.genmodel.utils.DistributionFamily;
import hex.genmodel.utils.LinkFunctionType;
import hex.genmodel.utils.ParseUtils;
import hex.genmodel.utils.StringEscapeUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ModelMojoReader<M extends MojoModel> {
    protected M _model;
    protected MojoReaderBackend _reader;
    private Map<String, Object> _lkv;

    public static MojoModel readFrom(MojoReaderBackend reader) throws IOException {
        return ModelMojoReader.readFrom(reader, false);
    }

    public static MojoModel readFrom(MojoReaderBackend reader, boolean readModelMetadata) throws IOException {
        try {
            Map<String, Object> map = ModelMojoReader.parseModelInfo(reader);
            if (!map.containsKey("algorithm")) {
                throw new IllegalStateException("Unable to find information about the model's algorithm.");
            }
            String string = String.valueOf(map.get("algorithm"));
            ModelMojoReader modelMojoReader = ModelMojoFactory.INSTANCE.getMojoReader(string);
            ModelMojoFactory.INSTANCE.getMojoReader(string)._lkv = map;
            modelMojoReader._reader = reader;
            modelMojoReader.readAll(readModelMetadata);
            Object m2 = modelMojoReader._model;
            return m2;
        }
        finally {
            if (reader instanceof Closeable) {
                ((Closeable)((Object)reader)).close();
            }
        }
    }

    public abstract String getModelName();

    protected abstract void readModelData() throws IOException;

    protected abstract M makeModel(String[] var1, String[][] var2, String var3);

    public abstract String mojoVersion();

    protected <T> T readkv(String key) {
        return this.readkv(key, null);
    }

    protected <T> T readkv(String key, T defVal) {
        Object object = this._lkv.get(key);
        if (!(object instanceof RawValue)) {
            if (object != null) {
                return (T)object;
            }
            return defVal;
        }
        return ((RawValue)object).parse(defVal);
    }

    protected byte[] readblob(String name) throws IOException {
        return this.getMojoReaderBackend().getBinaryFile(name);
    }

    protected boolean exists(String name) {
        return this.getMojoReaderBackend().exists(name);
    }

    protected Iterable<String> readtext(String name) throws IOException {
        return this.readtext(name, false);
    }

    protected Iterable<String> readtext(String name, boolean unescapeNewlines) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(50);
        BufferedReader bufferedReader = this.getMojoReaderBackend().getTextFile(name);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (unescapeNewlines) {
                    string = StringEscapeUtils.unescapeNewlines(string);
                }
                arrayList.add(string.trim());
            }
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return arrayList;
    }

    protected String[] readStringArray(String name, int size) throws IOException {
        String[] stringArray = new String[size];
        int n2 = 0;
        for (String string : this.readtext(name, true)) {
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    protected double[][] readRectangularDoubleArray(String title, int firstSize, int secondSize) throws IOException {
        assert (title != null);
        double[][] dArray = new double[firstSize][secondSize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < firstSize; ++i2) {
            for (int i3 = 0; i3 < secondSize; ++i3) {
                dArray[i2][i3] = byteBuffer.getDouble();
            }
        }
        return dArray;
    }

    protected double[][] readRectangularDoubleArray(String title) throws IOException {
        assert (title != null);
        int n2 = (Integer)this.readkv(title + "_size1");
        int n3 = (Integer)this.readkv(title + "_size2");
        return this.readRectangularDoubleArray(title, n2, n3);
    }

    private void readAll(boolean readModelMetadata) throws IOException {
        String[] stringArray = (String[])this._lkv.get("[columns]");
        String[][] stringArray2 = this.parseModelDomains(stringArray.length);
        boolean bl = (Boolean)this.readkv("supervised");
        this._model = this.makeModel(stringArray, stringArray2, bl ? stringArray[stringArray.length - 1] : null);
        ((MojoModel)this._model)._uuid = (String)this.readkv("uuid");
        ((MojoModel)this._model)._algoName = (String)this.readkv("algo");
        ((MojoModel)this._model)._h2oVersion = this.readkv("h2o_version", "unknown");
        ((MojoModel)this._model)._category = ModelCategory.valueOf((String)this.readkv("category"));
        ((MojoModel)this._model)._supervised = bl;
        ((MojoModel)this._model)._nfeatures = (Integer)this.readkv("n_features");
        ((MojoModel)this._model)._nclasses = (Integer)this.readkv("n_classes");
        ((MojoModel)this._model)._balanceClasses = (Boolean)this.readkv("balance_classes");
        ((MojoModel)this._model)._defaultThreshold = (Double)this.readkv("default_threshold");
        ((MojoModel)this._model)._priorClassDistrib = (double[])this.readkv("prior_class_distrib");
        ((MojoModel)this._model)._modelClassDistrib = (double[])this.readkv("model_class_distrib");
        ((MojoModel)this._model)._offsetColumn = (String)this.readkv("offset_column");
        ((MojoModel)this._model)._mojo_version = ((Number)this.readkv("mojo_version")).doubleValue();
        this.checkMaxSupportedMojoVersion();
        this.readModelData();
        if (readModelMetadata) {
            String string = (String)this.readkv("algorithm");
            ((MojoModel)this._model)._modelDescriptor = ModelDescriptorBuilder.makeDescriptor(this._model, string);
            ((MojoModel)this._model)._modelAttributes = this.readModelSpecificAttributes();
        }
        ((MojoModel)this._model)._reproducibilityInformation = this.readReproducibilityInformation();
    }

    protected Table[] readReproducibilityInformation() {
        m m2 = ModelJsonReader.parseModelJson(this._reader);
        if (m2 != null && m2.a("output") != null) {
            return ModelJsonReader.readTableArray(m2, "output.reproducibility_information_table");
        }
        return null;
    }

    protected ModelAttributes readModelSpecificAttributes() {
        m m2 = ModelJsonReader.parseModelJson(this._reader);
        if (m2 != null) {
            return new ModelAttributes((MojoModel)this._model, m2);
        }
        return null;
    }

    private static Map<String, Object> parseModelInfo(MojoReaderBackend reader) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        BufferedReader bufferedReader = reader.getTextFile("model.ini");
        try {
            String string;
            int n2 = 0;
            int n3 = 0;
            String[] stringArray = new String[]{};
            HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#") || string.isEmpty()) continue;
                if (string.equals("[info]")) {
                    n2 = 1;
                    continue;
                }
                if (string.equals("[columns]")) {
                    n2 = 2;
                    if (!hashMap.containsKey("n_columns")) {
                        throw new IOException("`n_columns` variable is missing in the model info.");
                    }
                    int n4 = Integer.parseInt(((RawValue)hashMap.get("n_columns"))._val);
                    stringArray = new String[n4];
                    hashMap.put("[columns]", stringArray);
                    continue;
                }
                if (string.equals("[domains]")) {
                    n2 = 3;
                    hashMap.put("[domains]", hashMap2);
                    continue;
                }
                if (n2 == 1) {
                    String[] stringArray2 = string.split("\\s*=\\s*", 2);
                    hashMap.put(stringArray2[0], stringArray2[0].equals("uuid") ? stringArray2[1] : new RawValue(stringArray2[1]));
                    continue;
                }
                if (n2 == 2) {
                    if (n3 >= stringArray.length) {
                        throw new IOException("`n_columns` variable is too small.");
                    }
                    stringArray[n3++] = string;
                    continue;
                }
                if (n2 != 3) continue;
                String[] stringArray3 = string.split(":\\s*", 2);
                int n5 = Integer.parseInt(stringArray3[0]);
                hashMap2.put(n5, stringArray3[1]);
            }
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[][] parseModelDomains(int n_columns) throws IOException {
        boolean bl = Boolean.TRUE.equals(this.readkv("escape_domain_values"));
        String[][] stringArray = new String[n_columns][];
        Map map = (Map)this._lkv.get("[domains]");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] stringArray2;
            block11: {
                Object object;
                Map.Entry entry = iterator.next();
                int n2 = (Integer)entry.getKey();
                if (n2 >= n_columns) continue;
                String[] stringArray3 = ((String)entry.getValue()).split(" ", 2);
                int n3 = Integer.parseInt(stringArray3[0]);
                String string = stringArray3[1];
                stringArray2 = new String[n3];
                BufferedReader bufferedReader = this.getMojoReaderBackend().getTextFile("domains/" + string);
                Throwable throwable = null;
                try {
                    int n4 = 0;
                    while ((object = bufferedReader.readLine()) != null) {
                        if (bl) {
                            object = StringEscapeUtils.unescapeNewlines((String)object);
                        }
                        stringArray2[n4++] = object;
                    }
                    if (n4 != n3) {
                        throw new IOException("Not enough elements in the domain file");
                    }
                    if (bufferedReader == null) break block11;
                }
                catch (Throwable throwable2) {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (bufferedReader == null) throw throwable3;
                        if (throwable == null) {
                            bufferedReader.close();
                            throw throwable3;
                        }
                        try {
                            bufferedReader.close();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                            throw throwable3;
                        }
                    }
                }
                bufferedReader.close();
            }
            stringArray[n2] = stringArray2;
        }
        return stringArray;
    }

    private void checkMaxSupportedMojoVersion() throws IOException {
        if (((MojoModel)this._model)._mojo_version > Double.parseDouble(this.mojoVersion())) {
            throw new IOException(String.format("MOJO version incompatibility - the model MOJO version (%.2f) is higher than the current H2O version (%s) supports. Please, use a newer version of H2O to load MOJO model.", ((MojoModel)this._model)._mojo_version, this.mojoVersion()));
        }
    }

    public static LinkFunctionType readLinkFunction(String linkFunctionTypeName, DistributionFamily family) {
        if (linkFunctionTypeName != null) {
            return LinkFunctionType.valueOf(linkFunctionTypeName);
        }
        return ModelMojoReader.defaultLinkFunction(family);
    }

    public static LinkFunctionType defaultLinkFunction(DistributionFamily family) {
        switch (family) {
            case bernoulli: 
            case fractionalbinomial: 
            case quasibinomial: 
            case modified_huber: 
            case ordinal: {
                return LinkFunctionType.logit;
            }
            case multinomial: 
            case poisson: 
            case gamma: 
            case tweedie: {
                return LinkFunctionType.log;
            }
        }
        return LinkFunctionType.identity;
    }

    protected MojoReaderBackend getMojoReaderBackend() {
        return this._reader;
    }

    private static class RawValue {
        private final String _val;

        RawValue(String val) {
            this._val = val;
        }

        <T> T parse(T defVal) {
            return (T)ParseUtils.tryParse(this._val, defVal);
        }

        public String toString() {
            return this._val;
        }
    }
}

