/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.gam.GamMojoModel;
import hex.genmodel.algos.gam.GamMojoModelBase;
import hex.genmodel.algos.gam.GamMojoMultinomialModel;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GamMojoReader
extends ModelMojoReader<GamMojoModelBase> {
    @Override
    public String getModelName() {
        return "Generalized Additive Model";
    }

    @Override
    protected void readModelData() throws IOException {
        int[] nArray;
        int[] nArray2;
        ((GamMojoModelBase)this._model)._useAllFactorLevels = this.readkv("use_all_factor_levels", Boolean.FALSE);
        ((GamMojoModelBase)this._model)._numExpandedGamCols = this.readkv("num_expanded_gam_columns", 0);
        ((GamMojoModelBase)this._model)._numExpandedGamColsCenter = this.readkv("num_expanded_gam_columns_center", 0);
        ((GamMojoModelBase)this._model)._family = DistributionFamily.valueOf((String)this.readkv("family"));
        ((GamMojoModelBase)this._model)._cats = this.readkv("cats", -1);
        ((GamMojoModelBase)this._model)._nums = (Integer)this.readkv("num");
        ((GamMojoModelBase)this._model)._numsCenter = (Integer)this.readkv("numsCenter");
        ((GamMojoModelBase)this._model)._catNAFills = this.readkv("catNAFills", new int[0]);
        ((GamMojoModelBase)this._model)._numNAFillsCenter = this.readkv("numNAFillsCenter", new double[0]);
        ((GamMojoModelBase)this._model)._meanImputation = this.readkv("mean_imputation", Boolean.FALSE);
        ((GamMojoModelBase)this._model)._betaSizePerClass = this.readkv("beta length per class", 0);
        ((GamMojoModelBase)this._model)._catOffsets = this.readkv("cat_offsets", new int[0]);
        if (!((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.multinomial)) {
            ((GamMojoModelBase)this._model)._link_function = GamMojoReader.readLinkFunction((String)this.readkv("link"), ((GamMojoModelBase)this._model)._family);
        }
        ((GamMojoModelBase)this._model)._tweedieLinkPower = this.readkv("tweedie_link_power", 0.0);
        ((GamMojoModelBase)this._model)._betaCenterSizePerClass = this.readkv("beta center length per class", 0);
        if (((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.multinomial) || ((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.ordinal)) {
            ((GamMojoModelBase)this._model)._beta_multinomial_no_center = this.readRectangularDoubleArray("beta_multinomial", ((GamMojoModelBase)this._model)._nclasses, ((GamMojoModelBase)this._model)._betaSizePerClass);
            ((GamMojoModelBase)this._model)._beta_multinomial_center = this.readRectangularDoubleArray("beta_multinomial_centering", ((GamMojoModelBase)this._model)._nclasses, ((GamMojoModelBase)this._model)._betaCenterSizePerClass);
        } else {
            ((GamMojoModelBase)this._model)._beta_no_center = (double[])this.readkv("beta");
            ((GamMojoModelBase)this._model)._beta_center = (double[])this.readkv("beta_center");
        }
        ((GamMojoModelBase)this._model)._num_knots = (int[])this.readkv("num_knots");
        ((GamMojoModelBase)this._model)._num_knots_sorted = (int[])this.readkv("num_knots_sorted");
        int[] nArray3 = (int[])this.readkv("gam_column_dim");
        ((GamMojoModelBase)this._model)._gam_columns = this.read2DStringArrays(nArray3, "gam_columns");
        int[] nArray4 = (int[])this.readkv("gam_column_dim_sorted");
        ((GamMojoModelBase)this._model)._gam_columns_sorted = this.read2DStringArrays(nArray4, "gam_columns_sorted");
        ((GamMojoModelBase)this._model)._num_gam_columns = ((GamMojoModelBase)this._model)._gam_columns.length;
        ((GamMojoModelBase)this._model)._num_TP_col = (Integer)this.readkv("num_TP_col");
        ((GamMojoModelBase)this._model)._num_CS_col = ((GamMojoModelBase)this._model)._num_gam_columns - ((GamMojoModelBase)this._model)._num_TP_col;
        ((GamMojoModelBase)this._model)._totFeatureSize = (Integer)this.readkv("total feature size");
        GamMojoReader gamMojoReader = this;
        ((GamMojoModelBase)this._model)._names_no_centering = gamMojoReader.readStringArrays(((GamMojoModelBase)gamMojoReader._model)._totFeatureSize, "_names_no_centering");
        ((GamMojoModelBase)this._model)._bs = (int[])this.readkv("bs");
        ((GamMojoModelBase)this._model)._bs_sorted = (int[])this.readkv("bs_sorted");
        ((GamMojoModelBase)this._model)._zTranspose = new double[((GamMojoModelBase)this._model)._num_gam_columns][][];
        int[] nArray5 = (int[])this.readkv("gamColName_dim");
        ((GamMojoModelBase)this._model)._gamColNames = this.read2DStringArrays(nArray5, "gamColNames");
        ((GamMojoModelBase)this._model)._gamColNames = new String[((GamMojoModelBase)this._model)._num_gam_columns][];
        ((GamMojoModelBase)this._model)._gamColNamesCenter = new String[((GamMojoModelBase)this._model)._num_gam_columns][];
        ((GamMojoModelBase)this._model)._gamPredSize = (int[])this.readkv("_d");
        if (((GamMojoModelBase)this._model)._num_TP_col > 0) {
            ((GamMojoModelBase)this._model)._standardize = (Boolean)this.readkv("standardize");
            ((GamMojoModelBase)this._model)._zTransposeCS = new double[((GamMojoModelBase)this._model)._num_TP_col][][];
            ((GamMojoModelBase)this._model)._num_knots_TP = (int[])this.readkv("num_knots_TP");
            ((GamMojoModelBase)this._model)._d = (int[])this.readkv("_d");
            ((GamMojoModelBase)this._model)._m = (int[])this.readkv("_m");
            ((GamMojoModelBase)this._model)._M = (int[])this.readkv("_M");
            nArray2 = new int[((GamMojoModelBase)this._model)._num_TP_col];
            System.arraycopy(nArray2, nArray2.length - ((GamMojoModelBase)this._model)._num_TP_col, nArray2, 0, ((GamMojoModelBase)this._model)._num_TP_col);
            ((GamMojoModelBase)this._model)._gamColMeansRaw = this.read2DDoubleArrays(nArray2, "gamColMeansRaw");
            ((GamMojoModelBase)this._model)._oneOGamColStd = this.read2DDoubleArrays(nArray2, "gamColStdRaw");
            nArray = ArrayUtils.subtract(((GamMojoModelBase)this._model)._num_knots_TP, ((GamMojoModelBase)this._model)._M);
            ((GamMojoModelBase)this._model)._zTransposeCS = this.read3DArray("zTransposeCS", ((GamMojoModelBase)this._model)._num_TP_col, nArray, ((GamMojoModelBase)this._model)._num_knots_TP);
            int[] nArray6 = new int[((GamMojoModelBase)this._model)._num_TP_col];
            System.arraycopy(((GamMojoModelBase)this._model)._d, ((GamMojoModelBase)this._model)._num_CS_col, nArray6, 0, ((GamMojoModelBase)this._model)._num_TP_col);
            ((GamMojoModelBase)this._model)._allPolyBasisList = this.read3DIntArray("polynomialBasisList", ((GamMojoModelBase)this._model)._num_TP_col, ((GamMojoModelBase)this._model)._M, nArray6);
        }
        nArray2 = ArrayUtils.subtract(((GamMojoModelBase)this._model)._num_knots_sorted, 1);
        ((GamMojoModelBase)this._model)._gamColNamesCenter = this.read2DStringArrays(nArray2, "gamColNamesCenter");
        ((GamMojoModelBase)this._model)._zTranspose = this.read3DArray("zTranspose", ((GamMojoModelBase)this._model)._num_gam_columns, nArray2, ((GamMojoModelBase)this._model)._num_knots_sorted);
        ((GamMojoModelBase)this._model)._knots = this.read3DArray("knots", ((GamMojoModelBase)this._model)._num_gam_columns, ((GamMojoModelBase)this._model)._gamPredSize, ((GamMojoModelBase)this._model)._num_knots_sorted);
        if (((GamMojoModelBase)this._model)._num_CS_col > 0) {
            nArray = ArrayUtils.subtract(((GamMojoModelBase)this._model)._num_knots_sorted, 2);
            ((GamMojoModelBase)this._model)._binvD = this.read3DArray("_binvD", ((GamMojoModelBase)this._model)._num_CS_col, nArray, ((GamMojoModelBase)this._model)._num_knots_sorted);
        }
        ((GamMojoModelBase)this._model).init();
    }

    String[] readStringArrays(int aSize, String title) throws IOException {
        String[] stringArray = new String[aSize];
        int n2 = 0;
        for (String string : this.readtext(title)) {
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    String[][] read2DStringArrays(int[] arrayDim, String title) throws IOException {
        int n2 = arrayDim.length;
        String[][] stringArray = new String[n2][];
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = new String[arrayDim[i2]];
        }
        for (String string : this.readtext(title)) {
            if (n4 >= stringArray[n3].length) {
                ++n3;
                n4 = 0;
            }
            stringArray[n3][n4] = string;
            ++n4;
        }
        return stringArray;
    }

    double[][] read2DDoubleArrays(int[] arrayDim, String title) throws IOException {
        int n2 = arrayDim.length;
        double[][] dArrayArray = new double[n2][];
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < n2; ++i2) {
            dArrayArray[i2] = new double[arrayDim[i2]];
            for (int i3 = 0; i3 < arrayDim[i2]; ++i3) {
                dArrayArray[i2][i3] = byteBuffer.getDouble();
            }
        }
        return dArrayArray;
    }

    double[][] read2DArray(String title, int firstDSize, int secondDSize) throws IOException {
        double[][] dArray = new double[firstDSize][secondDSize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < firstDSize; ++i2) {
            for (int i3 = 0; i3 < secondDSize; ++i3) {
                dArray[i2][i3] = byteBuffer.getDouble();
            }
        }
        return dArray;
    }

    int[][][] read3DIntArray(String title, int firstDimSize, int[] secondDim, int[] thirdDim) throws IOException {
        int[][][] nArrayArray = new int[firstDimSize][][];
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < firstDimSize; ++i2) {
            nArrayArray[i2] = new int[secondDim[i2]][thirdDim[i2]];
            for (int i3 = 0; i3 < secondDim[i2]; ++i3) {
                for (int i4 = 0; i4 < thirdDim[i2]; ++i4) {
                    nArrayArray[i2][i3][i4] = byteBuffer.getInt();
                }
            }
        }
        return nArrayArray;
    }

    double[][][] read3DArray(String title, int firstDimSize, int[] secondDim, int[] thirdDim) throws IOException {
        double[][][] dArrayArray = new double[firstDimSize][][];
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < firstDimSize; ++i2) {
            dArrayArray[i2] = new double[secondDim[i2]][thirdDim[i2]];
            for (int i3 = 0; i3 < secondDim[i2]; ++i3) {
                for (int i4 = 0; i4 < thirdDim[i2]; ++i4) {
                    dArrayArray[i2][i3][i4] = byteBuffer.getDouble();
                }
            }
        }
        return dArrayArray;
    }

    double[][] read2DArrayDiffLength(String title, double[][] row, int[] num_knots) throws IOException {
        int n2 = num_knots.length;
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < n2; ++i2) {
            row[i2] = new double[num_knots[i2]];
            for (int i3 = 0; i3 < row[i2].length; ++i3) {
                row[i2][i3] = byteBuffer.getDouble();
            }
        }
        return row;
    }

    @Override
    protected GamMojoModelBase makeModel(String[] columns, String[][] domains, String responseColumn) {
        String string = (String)this.readkv("family");
        if ("multinomial".equals(string) || "ordinal".equals(string)) {
            return new GamMojoMultinomialModel(columns, domains, responseColumn);
        }
        return new GamMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

