/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.utils.MathUtils;
import java.util.HashMap;
import java.util.Map;

public class BinaryEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap;
    private final int binaryCategorySizes;

    BinaryEncoder(String columnName, int targetIndex, String[] domainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        this.binaryCategorySizes = 1 + MathUtils.log2(domainValues.length - 1 + 1);
        this.domainMap = new HashMap<String, Integer>(domainValues.length);
        for (int i2 = 0; i2 < domainValues.length; ++i2) {
            this.domainMap.put(domainValues[i2], i2);
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer n2 = this.domainMap.get(levelName);
        if (n2 == null) {
            return false;
        }
        this.makeBinary(n2, rawData);
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        this.makeBinary(-1, rawData);
    }

    private void makeBinary(int index, double[] rawData) {
        long l2 = index + 1;
        for (int i2 = 0; i2 < this.binaryCategorySizes; ++i2) {
            rawData[this.targetIndex + i2] = l2 & 1L;
            l2 >>>= 1;
        }
    }

    public String toString() {
        return "BinaryEncoder{columnName='" + this.columnName + '\'' + ", targetIndex=" + this.targetIndex + ", domainMap=" + this.domainMap + '}';
    }
}

