/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class EnumLimitedEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap = new HashMap<String, Integer>();

    EnumLimitedEncoder(String columnName, int targetIndex, String[] domainValues, String[] newDomainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        for (int i2 = 0; i2 < newDomainValues.length; ++i2) {
            this.domainMap.put(newDomainValues[i2], i2);
        }
        if (this.domainMap.containsKey("other")) {
            Integer n2 = this.domainMap.get("other");
            for (int i3 = 0; i3 < domainValues.length; ++i3) {
                if (this.domainMap.containsKey(domainValues[i3])) continue;
                this.domainMap.put(domainValues[i3], n2);
            }
            this.domainMap.remove("other");
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer n2 = this.domainMap.get(levelName);
        if (n2 == null) {
            n2 = this.domainMap.get(this.columnName + ".top_" + levelName + "_levels");
        }
        if (n2 == null) {
            return false;
        }
        rawData[this.targetIndex] = n2.intValue();
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        rawData[this.targetIndex] = Double.NaN;
    }

    public String toString() {
        return "EnumLimited{columnName='" + this.columnName + '\'' + ", targetIndex=" + this.targetIndex + ", domainMap=" + this.domainMap + '}';
    }
}

