/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import hex.genmodel.MojoPipelineBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BuildPipeline {
    private File _output;
    private Map<String, File> _input;
    private List<MojoPipelineBuilder.MappingSpec> _mappings;

    public static void main(String[] args) {
        BuildPipeline buildPipeline = new BuildPipeline();
        buildPipeline.parseArgs(args);
        try {
            buildPipeline.run();
            return;
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(2);
            return;
        }
    }

    private void run() throws Exception {
        String string = this.findMainModel();
        MojoPipelineBuilder mojoPipelineBuilder = new MojoPipelineBuilder();
        for (Map.Entry<String, File> entry : this._input.entrySet()) {
            if (string.equals(entry.getKey())) continue;
            mojoPipelineBuilder.addModel(entry.getKey(), entry.getValue());
        }
        mojoPipelineBuilder.addMappings(this._mappings).addMainModel(string, this._input.get(string)).buildPipeline(this._output);
    }

    private String findMainModel() {
        HashSet<String> hashSet = new HashSet<String>();
        for (MojoPipelineBuilder.MappingSpec object : this._mappings) {
            hashSet.add(object._modelAlias);
        }
        HashSet hashSet2 = new HashSet();
        for (String string : this._input.keySet()) {
            if (hashSet.contains(string)) continue;
            hashSet2.add(string);
        }
        if (hashSet2.size() != 1) {
            throw new IllegalStateException("Main model cannot be identified, main should be the only model that doesn't have output mappings. Candidates: " + ((Object)hashSet2).toString());
        }
        return (String)hashSet2.iterator().next();
    }

    private static void usage() {
        System.out.println("");
        System.out.println("Usage:  java [...java args...] hex.genmodel.tools.BuildPipeline ");
        System.out.println("             --mapping <inputMapping1> <inputMapping2> ... --output <outputFile> --input <inputFile1> <inputFile2> ...");
        System.out.println("");
        System.out.println("     --mapping Mapping of model predictions to main model inputs.");
        System.out.println("               Example: Specify 'CLUSTER=clustering:0' to use a model defined in a MOJO file 'clustering.zip'");
        System.out.println("                        and map the predicted cluster (output 0) to input column 'CLUSTER' of the main model.");
        System.out.println("     --input   List of input MOJO files representing both the main model and the prerequisite models.");
        System.out.println("     --output  Name of the generated MOJO pipeline file.");
        System.out.println("");
        System.out.println("     Input mappings are specified in format '<columnName>=<modelAlias>:<predictionIndex>'.");
        System.out.println("");
        System.out.println("     Model alias is based on the name of the MOJO file.");
        System.out.println("     For example, a MOJO stored in 'glm_model.zip' will have the alias 'glm_model'.");
        System.out.println("");
        System.out.println("Note: There is no need to specify which of the MOJO model represents the main model. The tool");
        System.out.println("automatically identifies the main model as the one that doesn't have any output mappings.");
        System.out.println("");
        System.exit(1);
    }

    private void parseArgs(String[] args) {
        try {
            for (int i2 = 0; i2 < args.length; ++i2) {
                List<String> list;
                String string = args[i2];
                if (string.equals("--mapping")) {
                    list = BuildPipeline.readArgValues(args, i2 + 1);
                    this._mappings = new ArrayList<MojoPipelineBuilder.MappingSpec>(list.size());
                    for (String string2 : list) {
                        try {
                            this._mappings.add(MojoPipelineBuilder.MappingSpec.parse(string2));
                        }
                        catch (Exception exception) {
                            throw new IllegalArgumentException("Invalid mapping specified ('" + string2 + "'. Please use format '<columnName>=<modelAlias>:<predictionIndex>'.");
                        }
                    }
                    i2 += list.size();
                    continue;
                }
                if (string.equals("--output")) {
                    list = BuildPipeline.readArgValues(args, i2 + 1);
                    if (list.size() != 1) {
                        throw new IllegalArgumentException("Invalid specification of the output file (" + list.toString() + "). Please specify only a single output file.");
                    }
                    this._output = new File(list.get(0));
                    ++i2;
                    continue;
                }
                if (string.equals("--input")) {
                    list = BuildPipeline.readArgValues(args, i2 + 1);
                    if (list.size() < 2) {
                        throw new IllegalArgumentException("Pipeline needs at least 2 input files, only " + list.size() + " specified.");
                    }
                    this._input = this.makeAliases(list);
                    i2 += list.size();
                    continue;
                }
                System.out.println("ERROR: Unknown command line argument: " + string);
                BuildPipeline.usage();
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception.getMessage());
            exception.printStackTrace();
            BuildPipeline.usage();
        }
        if (this._input == null) {
            System.err.println("ERROR: Missing mandatory argument '--output'");
            BuildPipeline.usage();
        }
        if (this._output == null) {
            System.err.println("ERROR: Missing mandatory argument '--input'");
            BuildPipeline.usage();
        }
        if (this._mappings == null) {
            System.err.println("ERROR: Missing mandatory argument '--mapping'");
            BuildPipeline.usage();
        }
    }

    private Map<String, File> makeAliases(List<String> paths) {
        HashMap<String, File> hashMap = new HashMap<String, File>(paths.size());
        for (String string : paths) {
            File file = new File(string);
            String string2 = file.getName();
            int n2 = string2.lastIndexOf(".");
            String string3 = n2 >= 0 ? string2.substring(0, n2) : string2;
            hashMap.put(string3, file);
        }
        return hashMap;
    }

    private static List<String> readArgValues(String[] args, int startIdx) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i2 = startIdx; i2 < args.length && !args[i2].startsWith("--"); ++i2) {
            linkedList.add(args[i2]);
        }
        return linkedList;
    }
}

