/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class ArrayUtils {
    public static double[] nanArray(int len) {
        double[] dArray = new double[len];
        for (int i2 = 0; i2 < len; ++i2) {
            dArray[i2] = Double.NaN;
        }
        return dArray;
    }

    public static double l2norm(double[] x2) {
        return Math.sqrt(ArrayUtils.l2norm2(x2));
    }

    public static double l2norm2(double[] x2) {
        return ArrayUtils.l2norm2(x2, false);
    }

    public static double l2norm2(double[] x2, boolean skipLast) {
        int n2 = x2.length - (skipLast ? 1 : 0);
        double d2 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += x2[i2] * x2[i2];
        }
        return d2;
    }

    public static double[] flat(double[][] arr) {
        int n2;
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return null;
        }
        int n3 = 0;
        Object object = arr;
        int n4 = arr.length;
        for (n2 = 0; n2 < n4; ++n2) {
            double[] dArray = object[n2];
            n3 += dArray != null ? dArray.length : 0;
        }
        object = Arrays.copyOf(arr[0], n3);
        n4 = arr[0].length;
        for (n2 = 1; n2 < arr.length; ++n2) {
            if (arr[n2] == null) continue;
            System.arraycopy(arr[n2], 0, object, n4, arr[n2].length);
            n4 += arr[n2].length;
        }
        return object;
    }

    public static double[] eleDiff(double[] from) {
        int n2 = from.length - 1;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = from[i2 + 1] - from[i2];
        }
        return dArray;
    }

    public static int[] subtract(int[] from, int val) {
        int n2 = from.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = from[i2] - val;
        }
        return nArray;
    }

    public static int[] subtract(int[] from, int[] val) {
        int n2 = from.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = from[i2] - val[i2];
        }
        return nArray;
    }

    public static boolean isBoolColumn(String[] domains) {
        if (domains != null) {
            if (domains.length == 2) {
                if (domains[0].equalsIgnoreCase("true") && domains[1].equalsIgnoreCase("false")) {
                    return true;
                }
                if (domains[1].equalsIgnoreCase("true") && domains[0].equalsIgnoreCase("false")) {
                    return true;
                }
            } else if (domains.length == 1 && (domains[0].equalsIgnoreCase("true") || domains[0].equalsIgnoreCase("false"))) {
                return true;
            }
        }
        return false;
    }

    public static int maxIndex(double[] from, Random rand) {
        assert (rand != null);
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] > from[n2]) {
                n2 = i2;
                n3 = 1;
                continue;
            }
            if (from[i2] != from[n2] || rand.nextInt(++n3) != 0) continue;
            n2 = i2;
        }
        return n2;
    }

    public static int maxIndex(double[] from) {
        int n2 = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (!(from[i2] > from[n2])) continue;
            n2 = i2;
        }
        return n2;
    }

    public static void sort(int[] idxs, double[] values) {
        ArrayUtils.sort(idxs, values, 500);
    }

    public static void sort(int[] idxs, final double[] values, int cutoff) {
        int n2;
        if (idxs.length < cutoff) {
            for (int i2 = 0; i2 < idxs.length; ++i2) {
                for (int i3 = i2; i3 > 0 && values[idxs[i3 - 1]] > values[idxs[i3]]; --i3) {
                    int n3 = idxs[i3];
                    idxs[i3] = idxs[i3 - 1];
                    idxs[i3 - 1] = n3;
                }
            }
            return;
        }
        Integer[] integerArray = new Integer[idxs.length];
        for (n2 = 0; n2 < idxs.length; ++n2) {
            integerArray[n2] = idxs[n2];
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public final int compare(Integer x2, Integer y2) {
                if (values[x2] < values[y2]) {
                    return -1;
                }
                if (values[x2] > values[y2]) {
                    return 1;
                }
                return 0;
            }
        });
        for (n2 = 0; n2 < idxs.length; ++n2) {
            idxs[n2] = integerArray[n2];
        }
    }

    public static String[] append(String[] a2, String ... b2) {
        if (a2 == null) {
            return b2;
        }
        String[] stringArray = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, stringArray, a2.length, b2.length);
        return stringArray;
    }

    public static String[][] append(String[][] a2, String[] ... b2) {
        if (a2 == null) {
            return b2;
        }
        String[][] stringArray = (String[][])Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, stringArray, a2.length, b2.length);
        return stringArray;
    }

    public static double[] signum(double[] array) {
        double[] dArray = new double[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            dArray[i2] = array[i2] > 0.0 ? 1.0 : (array[i2] < 0.0 ? -1.0 : 0.0);
        }
        return dArray;
    }

    public static double[] difference(double[] array) {
        double[] dArray = new double[array.length - 1];
        for (int i2 = 0; i2 < array.length - 1; ++i2) {
            dArray[i2] = array[i2 + 1] - array[i2];
        }
        return dArray;
    }

    public static void multArray(double[] a2, double[][] bT, double[] result) {
        int n2 = result.length;
        int n3 = a2.length;
        Arrays.fill(result, 0.0);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int n4 = i2;
                result[n4] = result[n4] + a2[i3] * bT[i2][i3];
            }
        }
    }
}

