/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.MethodUtils;

public class ConstructorUtils {
    private static final Class<?>[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> T invokeConstructor(Class<T> klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray = ConstructorUtils.toArray(arg);
        return ConstructorUtils.invokeConstructor(klass, objectArray);
    }

    public static <T> T invokeConstructor(Class<T> klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int n2 = args.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = args[i2].getClass();
        }
        return ConstructorUtils.invokeConstructor(klass, args, classArray);
    }

    public static <T> T invokeConstructor(Class<T> klass, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if ((constructor = ConstructorUtils.getMatchingAccessibleConstructor(klass, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return constructor.newInstance(args);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray = ConstructorUtils.toArray(arg);
        return ConstructorUtils.invokeExactConstructor(klass, objectArray);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int n2 = args.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = args[i2].getClass();
        }
        return ConstructorUtils.invokeExactConstructor(klass, args, classArray);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((constructor = ConstructorUtils.getAccessibleConstructor(klass, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return constructor.newInstance(args);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> klass, Class<?> parameterType) {
        Class[] classArray = new Class[]{parameterType};
        return ConstructorUtils.getAccessibleConstructor(klass, classArray);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> klass, Class<?>[] parameterTypes) {
        try {
            return ConstructorUtils.getAccessibleConstructor(klass.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> ctor) {
        if (ctor == null) {
            return null;
        }
        if (!Modifier.isPublic(ctor.getModifiers())) {
            return null;
        }
        Class<T> clazz = ctor.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return ctor;
        }
        return null;
    }

    private static Object[] toArray(Object arg) {
        Object[] objectArray = null;
        if (arg != null) {
            objectArray = new Object[]{arg};
        }
        return objectArray;
    }

    private static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> clazz, Class<?>[] parameterTypes) {
        try {
            Constructor<T> constructor = clazz.getConstructor(parameterTypes);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {}
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?>[] constructorArray;
            int n2 = parameterTypes.length;
            Constructor<?>[] constructorArray2 = constructorArray = clazz.getConstructors();
            int n3 = constructorArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Constructor<?> constructor;
                Constructor<?> constructor2 = constructorArray2[i2];
                Class<?>[] classArray = constructor2.getParameterTypes();
                int n4 = classArray.length;
                if (n4 != n2) continue;
                boolean bl = true;
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (MethodUtils.isAssignmentCompatible(classArray[i3], parameterTypes[i3])) continue;
                    bl = false;
                    break;
                }
                if (!bl || (constructor = ConstructorUtils.getAccessibleConstructor(constructor2)) == null) continue;
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {}
                Constructor<?> constructor3 = constructor;
                return constructor3;
            }
            return null;
        }
    }
}

