/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.MutableDynaClass;

public class LazyDynaClass
extends BasicDynaClass
implements MutableDynaClass {
    protected boolean restricted;
    protected boolean returnNull = false;

    public LazyDynaClass() {
        this((String)null, (DynaProperty[])null);
    }

    public LazyDynaClass(String name) {
        this(name, (DynaProperty[])null);
    }

    public LazyDynaClass(String name, Class<?> dynaBeanClass) {
        this(name, dynaBeanClass, null);
    }

    public LazyDynaClass(String name, DynaProperty[] properties) {
        this(name, LazyDynaBean.class, properties);
    }

    public LazyDynaClass(String name, Class<?> dynaBeanClass, DynaProperty[] properties) {
        super(name, dynaBeanClass, properties);
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    @Override
    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    @Override
    public void add(String name) {
        this.add(new DynaProperty(name));
    }

    @Override
    public void add(String name, Class<?> type) {
        if (type == null) {
            this.add(name);
            return;
        }
        this.add(new DynaProperty(name, type));
    }

    @Override
    public void add(String name, Class<?> type, boolean readable, boolean writeable) {
        throw new UnsupportedOperationException("readable/writable properties not supported");
    }

    protected void add(DynaProperty property) {
        if (property.getName() == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No new properties can be added.");
        }
        if (this.propertiesMap.get(property.getName()) != null) {
            return;
        }
        DynaProperty[] dynaPropertyArray = this.getDynaProperties();
        DynaProperty[] dynaPropertyArray2 = new DynaProperty[dynaPropertyArray.length + 1];
        System.arraycopy(dynaPropertyArray, 0, dynaPropertyArray2, 0, dynaPropertyArray.length);
        dynaPropertyArray2[dynaPropertyArray.length] = property;
        this.setProperties(dynaPropertyArray2);
    }

    @Override
    public void remove(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No properties can be removed.");
        }
        if (this.propertiesMap.get(name) == null) {
            return;
        }
        DynaProperty[] dynaPropertyArray = this.getDynaProperties();
        DynaProperty[] dynaPropertyArray2 = new DynaProperty[dynaPropertyArray.length - 1];
        int n2 = 0;
        for (int i2 = 0; i2 < dynaPropertyArray.length; ++i2) {
            if (name.equals(dynaPropertyArray[i2].getName())) continue;
            dynaPropertyArray2[n2] = dynaPropertyArray[i2];
            ++n2;
        }
        this.setProperties(dynaPropertyArray2);
    }

    @Override
    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        DynaProperty dynaProperty = (DynaProperty)this.propertiesMap.get(name);
        if (dynaProperty == null && !this.isReturnNull() && !this.isRestricted()) {
            dynaProperty = new DynaProperty(name);
        }
        return dynaProperty;
    }

    public boolean isDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        return this.propertiesMap.get(name) != null;
    }
}

