/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.list.FixedSizeList;
import org.apache.commons.collections.list.LazyList;
import org.apache.commons.collections.list.PredicatedList;
import org.apache.commons.collections.list.SynchronizedList;
import org.apache.commons.collections.list.TransformedList;
import org.apache.commons.collections.list.TypedList;
import org.apache.commons.collections.list.UnmodifiableList;

public class ListUtils {
    public static final List EMPTY_LIST = Collections.EMPTY_LIST;

    public static List intersection(List list1, List list2) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!list1.contains(e2)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public static List subtract(List list1, List list2) {
        ArrayList arrayList = new ArrayList(list1);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            arrayList.remove(iterator.next());
        }
        return arrayList;
    }

    public static List sum(List list1, List list2) {
        return ListUtils.subtract(ListUtils.union(list1, list2), ListUtils.intersection(list1, list2));
    }

    public static List union(List list1, List list2) {
        ArrayList arrayList = new ArrayList(list1);
        arrayList.addAll(list2);
        return arrayList;
    }

    public static boolean isEqualList(Collection list1, Collection list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null || list1.size() != list2.size()) {
            return false;
        }
        Iterator iterator = list1.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object e2 = iterator.next();
            Object e3 = iterator2.next();
            if (e2 != null ? e2.equals(e3) : e3 == null) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    public static int hashCodeForList(Collection list) {
        if (list == null) {
            return 0;
        }
        int n2 = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            n2 = n2 * 31 + (e2 == null ? 0 : e2.hashCode());
        }
        return n2;
    }

    public static List retainAll(Collection collection, Collection retain) {
        ArrayList arrayList = new ArrayList(Math.min(collection.size(), retain.size()));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!retain.contains(e2)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public static List removeAll(Collection collection, Collection remove) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (remove.contains(e2)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public static List synchronizedList(List list) {
        return SynchronizedList.decorate(list);
    }

    public static List unmodifiableList(List list) {
        return UnmodifiableList.decorate(list);
    }

    public static List predicatedList(List list, Predicate predicate) {
        return PredicatedList.decorate(list, predicate);
    }

    public static List typedList(List list, Class type) {
        return TypedList.decorate(list, type);
    }

    public static List transformedList(List list, Transformer transformer) {
        return TransformedList.decorate(list, transformer);
    }

    public static List lazyList(List list, Factory factory) {
        return LazyList.decorate(list, factory);
    }

    public static List fixedSizeList(List list) {
        return FixedSizeList.decorate(list);
    }
}

