/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.FixedSizeMap;
import org.apache.commons.collections.map.FixedSizeSortedMap;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.collections.map.LazySortedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.collections.map.PredicatedMap;
import org.apache.commons.collections.map.PredicatedSortedMap;
import org.apache.commons.collections.map.TransformedMap;
import org.apache.commons.collections.map.TransformedSortedMap;
import org.apache.commons.collections.map.TypedMap;
import org.apache.commons.collections.map.TypedSortedMap;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.commons.collections.map.UnmodifiableSortedMap;

public class MapUtils {
    public static final Map EMPTY_MAP = UnmodifiableMap.decorate(new HashMap(1));
    public static final SortedMap EMPTY_SORTED_MAP = UnmodifiableSortedMap.decorate(new TreeMap());
    private static final String INDENT_STRING = "    ";

    public static Object getObject(Map map, Object key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static String getString(Map map, Object key) {
        Object v2;
        if (map != null && (v2 = map.get(key)) != null) {
            return v2.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map map, Object key) {
        Object v2;
        if (map != null && (v2 = map.get(key)) != null) {
            if (v2 instanceof Boolean) {
                return (Boolean)v2;
            }
            if (v2 instanceof String) {
                return new Boolean((String)v2);
            }
            if (v2 instanceof Number) {
                Number number = (Number)v2;
                if (number.intValue() != 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static Number getNumber(Map map, Object key) {
        Object v2;
        if (map != null && (v2 = map.get(key)) != null) {
            if (v2 instanceof Number) {
                return (Number)v2;
            }
            if (v2 instanceof String) {
                try {
                    String string = (String)v2;
                    return NumberFormat.getInstance().parse(string);
                }
                catch (ParseException parseException) {}
            }
        }
        return null;
    }

    public static Byte getByte(Map map, Object key) {
        Number number = MapUtils.getNumber(map, key);
        if (number == null) {
            return null;
        }
        if (number instanceof Byte) {
            return (Byte)number;
        }
        return new Byte(number.byteValue());
    }

    public static Short getShort(Map map, Object key) {
        Number number = MapUtils.getNumber(map, key);
        if (number == null) {
            return null;
        }
        if (number instanceof Short) {
            return (Short)number;
        }
        return new Short(number.shortValue());
    }

    public static Integer getInteger(Map map, Object key) {
        Number number = MapUtils.getNumber(map, key);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return new Integer(number.intValue());
    }

    public static Long getLong(Map map, Object key) {
        Number number = MapUtils.getNumber(map, key);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return new Long(number.longValue());
    }

    public static Float getFloat(Map map, Object key) {
        Number number = MapUtils.getNumber(map, key);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return new Float(number.floatValue());
    }

    public static Double getDouble(Map map, Object key) {
        Number number = MapUtils.getNumber(map, key);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return new Double(number.doubleValue());
    }

    public static Map getMap(Map map, Object key) {
        Object v2;
        if (map != null && (v2 = map.get(key)) != null && v2 instanceof Map) {
            return (Map)v2;
        }
        return null;
    }

    public static Object getObject(Map map, Object key, Object defaultValue) {
        Object v2;
        if (map != null && (v2 = map.get(key)) != null) {
            return v2;
        }
        return defaultValue;
    }

    public static String getString(Map map, Object key, String defaultValue) {
        String string = MapUtils.getString(map, key);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    public static Boolean getBoolean(Map map, Object key, Boolean defaultValue) {
        Boolean bl = MapUtils.getBoolean(map, key);
        if (bl == null) {
            bl = defaultValue;
        }
        return bl;
    }

    public static Number getNumber(Map map, Object key, Number defaultValue) {
        Number number = MapUtils.getNumber(map, key);
        if (number == null) {
            number = defaultValue;
        }
        return number;
    }

    public static Byte getByte(Map map, Object key, Byte defaultValue) {
        Byte by = MapUtils.getByte(map, key);
        if (by == null) {
            by = defaultValue;
        }
        return by;
    }

    public static Short getShort(Map map, Object key, Short defaultValue) {
        Short s2 = MapUtils.getShort(map, key);
        if (s2 == null) {
            s2 = defaultValue;
        }
        return s2;
    }

    public static Integer getInteger(Map map, Object key, Integer defaultValue) {
        Integer n2 = MapUtils.getInteger(map, key);
        if (n2 == null) {
            n2 = defaultValue;
        }
        return n2;
    }

    public static Long getLong(Map map, Object key, Long defaultValue) {
        Long l2 = MapUtils.getLong(map, key);
        if (l2 == null) {
            l2 = defaultValue;
        }
        return l2;
    }

    public static Float getFloat(Map map, Object key, Float defaultValue) {
        Float f2 = MapUtils.getFloat(map, key);
        if (f2 == null) {
            f2 = defaultValue;
        }
        return f2;
    }

    public static Double getDouble(Map map, Object key, Double defaultValue) {
        Double d2 = MapUtils.getDouble(map, key);
        if (d2 == null) {
            d2 = defaultValue;
        }
        return d2;
    }

    public static Map getMap(Map map, Object key, Map defaultValue) {
        Map map2 = MapUtils.getMap(map, key);
        if (map2 == null) {
            map2 = defaultValue;
        }
        return map2;
    }

    public static boolean getBooleanValue(Map map, Object key) {
        Boolean bl = MapUtils.getBoolean(map, key);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static byte getByteValue(Map map, Object key) {
        Byte by = MapUtils.getByte(map, key);
        if (by == null) {
            return 0;
        }
        return by;
    }

    public static short getShortValue(Map map, Object key) {
        Short s2 = MapUtils.getShort(map, key);
        if (s2 == null) {
            return 0;
        }
        return s2;
    }

    public static int getIntValue(Map map, Object key) {
        Integer n2 = MapUtils.getInteger(map, key);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public static long getLongValue(Map map, Object key) {
        Long l2 = MapUtils.getLong(map, key);
        if (l2 == null) {
            return 0L;
        }
        return l2;
    }

    public static float getFloatValue(Map map, Object key) {
        Float f2 = MapUtils.getFloat(map, key);
        if (f2 == null) {
            return 0.0f;
        }
        return f2.floatValue();
    }

    public static double getDoubleValue(Map map, Object key) {
        Double d2 = MapUtils.getDouble(map, key);
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    public static boolean getBooleanValue(Map map, Object key, boolean defaultValue) {
        Boolean bl = MapUtils.getBoolean(map, key);
        if (bl == null) {
            return defaultValue;
        }
        return bl;
    }

    public static byte getByteValue(Map map, Object key, byte defaultValue) {
        Byte by = MapUtils.getByte(map, key);
        if (by == null) {
            return defaultValue;
        }
        return by;
    }

    public static short getShortValue(Map map, Object key, short defaultValue) {
        Short s2 = MapUtils.getShort(map, key);
        if (s2 == null) {
            return defaultValue;
        }
        return s2;
    }

    public static int getIntValue(Map map, Object key, int defaultValue) {
        Integer n2 = MapUtils.getInteger(map, key);
        if (n2 == null) {
            return defaultValue;
        }
        return n2;
    }

    public static long getLongValue(Map map, Object key, long defaultValue) {
        Long l2 = MapUtils.getLong(map, key);
        if (l2 == null) {
            return defaultValue;
        }
        return l2;
    }

    public static float getFloatValue(Map map, Object key, float defaultValue) {
        Float f2 = MapUtils.getFloat(map, key);
        if (f2 == null) {
            return defaultValue;
        }
        return f2.floatValue();
    }

    public static double getDoubleValue(Map map, Object key, double defaultValue) {
        Double d2 = MapUtils.getDouble(map, key);
        if (d2 == null) {
            return defaultValue;
        }
        return d2;
    }

    public static Properties toProperties(Map map) {
        Properties properties = new Properties();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                properties.put(k2, v2);
            }
        }
        return properties;
    }

    public static Map toMap(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object = resourceBundle.getObject(string);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public static void verbosePrint(PrintStream out, Object label, Map map) {
        MapUtils.verbosePrintInternal(out, label, map, new ArrayStack(), false);
    }

    public static void debugPrint(PrintStream out, Object label, Map map) {
        MapUtils.verbosePrintInternal(out, label, map, new ArrayStack(), true);
    }

    protected static void logInfo(Exception ex) {
        System.out.println("INFO: Exception: " + ex);
    }

    private static void verbosePrintInternal(PrintStream out, Object label, Map map, ArrayStack lineage, boolean debug) {
        MapUtils.printIndent(out, lineage.size());
        if (map == null) {
            if (label != null) {
                out.print(label);
                out.print(" = ");
            }
            out.println("null");
            return;
        }
        if (label != null) {
            out.print(label);
            out.println(" = ");
        }
        MapUtils.printIndent(out, lineage.size());
        out.println("{");
        lineage.push(map);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            if (v2 instanceof Map && !lineage.contains(v2)) {
                MapUtils.verbosePrintInternal(out, k2 == null ? "null" : k2, (Map)v2, lineage, debug);
                continue;
            }
            MapUtils.printIndent(out, lineage.size());
            out.print(k2);
            out.print(" = ");
            int n2 = lineage.indexOf(v2);
            if (n2 == -1) {
                out.print(v2);
            } else if (lineage.size() - 1 == n2) {
                out.print("(this Map)");
            } else {
                out.print("(ancestor[" + (lineage.size() - 1 - n2 - 1) + "] Map)");
            }
            if (debug && v2 != null) {
                out.print(' ');
                out.println(v2.getClass().getName());
                continue;
            }
            out.println();
        }
        lineage.pop();
        MapUtils.printIndent(out, lineage.size());
        out.println(debug ? "} " + map.getClass().getName() : "}");
    }

    private static void printIndent(PrintStream out, int indent) {
        for (int i2 = 0; i2 < indent; ++i2) {
            out.print(INDENT_STRING);
        }
    }

    public static Map invertMap(Map map) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    public static void safeAddToMap(Map map, Object key, Object value) throws NullPointerException {
        if (value == null) {
            map.put(key, "");
            return;
        }
        map.put(key, value);
    }

    public static Map putAll(Map map, Object[] array) {
        map.size();
        if (array == null || array.length == 0) {
            return map;
        }
        Object object = array[0];
        if (object instanceof Map.Entry) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                Map.Entry entry = (Map.Entry)array[i2];
                map.put(entry.getKey(), entry.getValue());
            }
        } else if (object instanceof KeyValue) {
            for (int i3 = 0; i3 < array.length; ++i3) {
                KeyValue keyValue = (KeyValue)array[i3];
                map.put(keyValue.getKey(), keyValue.getValue());
            }
        } else if (object instanceof Object[]) {
            for (int i4 = 0; i4 < array.length; ++i4) {
                Object[] objectArray = (Object[])array[i4];
                if (objectArray == null || objectArray.length < 2) {
                    throw new IllegalArgumentException("Invalid array element: " + i4);
                }
                map.put(objectArray[0], objectArray[1]);
            }
        } else {
            int n2 = 0;
            while (n2 < array.length - 1) {
                map.put(array[n2++], array[n2++]);
            }
        }
        return map;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !MapUtils.isEmpty(map);
    }

    public static Map synchronizedMap(Map map) {
        return Collections.synchronizedMap(map);
    }

    public static Map unmodifiableMap(Map map) {
        return UnmodifiableMap.decorate(map);
    }

    public static Map predicatedMap(Map map, Predicate keyPred, Predicate valuePred) {
        return PredicatedMap.decorate(map, keyPred, valuePred);
    }

    public static Map typedMap(Map map, Class keyType, Class valueType) {
        return TypedMap.decorate(map, keyType, valueType);
    }

    public static Map transformedMap(Map map, Transformer keyTransformer, Transformer valueTransformer) {
        return TransformedMap.decorate(map, keyTransformer, valueTransformer);
    }

    public static Map fixedSizeMap(Map map) {
        return FixedSizeMap.decorate(map);
    }

    public static Map lazyMap(Map map, Factory factory) {
        return LazyMap.decorate(map, factory);
    }

    public static Map lazyMap(Map map, Transformer transformerFactory) {
        return LazyMap.decorate(map, transformerFactory);
    }

    public static Map orderedMap(Map map) {
        return ListOrderedMap.decorate(map);
    }

    public static Map multiValueMap(Map map) {
        return MultiValueMap.decorate(map);
    }

    public static Map multiValueMap(Map map, Class collectionClass) {
        return MultiValueMap.decorate(map, collectionClass);
    }

    public static Map multiValueMap(Map map, Factory collectionFactory) {
        return MultiValueMap.decorate(map, collectionFactory);
    }

    public static Map synchronizedSortedMap(SortedMap map) {
        return Collections.synchronizedSortedMap(map);
    }

    public static Map unmodifiableSortedMap(SortedMap map) {
        return UnmodifiableSortedMap.decorate(map);
    }

    public static SortedMap predicatedSortedMap(SortedMap map, Predicate keyPred, Predicate valuePred) {
        return PredicatedSortedMap.decorate(map, keyPred, valuePred);
    }

    public static SortedMap typedSortedMap(SortedMap map, Class keyType, Class valueType) {
        return TypedSortedMap.decorate(map, keyType, valueType);
    }

    public static SortedMap transformedSortedMap(SortedMap map, Transformer keyTransformer, Transformer valueTransformer) {
        return TransformedSortedMap.decorate(map, keyTransformer, valueTransformer);
    }

    public static SortedMap fixedSizeSortedMap(SortedMap map) {
        return FixedSizeSortedMap.decorate(map);
    }

    public static SortedMap lazySortedMap(SortedMap map, Factory factory) {
        return LazySortedMap.decorate(map, factory);
    }

    public static SortedMap lazySortedMap(SortedMap map, Transformer transformerFactory) {
        return LazySortedMap.decorate(map, transformerFactory);
    }
}

