/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.NOPClosure;

public class SwitchClosure
implements Serializable,
Closure {
    private static final long serialVersionUID = 3518477308466486130L;
    private final Predicate[] iPredicates;
    private final Closure[] iClosures;
    private final Closure iDefault;

    public static Closure getInstance(Predicate[] predicates, Closure[] closures, Closure defaultClosure) {
        FunctorUtils.validate(predicates);
        FunctorUtils.validate(closures);
        if (predicates.length != closures.length) {
            throw new IllegalArgumentException("The predicate and closure arrays must be the same size");
        }
        if (predicates.length == 0) {
            if (defaultClosure == null) {
                return NOPClosure.INSTANCE;
            }
            return defaultClosure;
        }
        predicates = FunctorUtils.copy(predicates);
        closures = FunctorUtils.copy(closures);
        return new SwitchClosure(predicates, closures, defaultClosure);
    }

    public static Closure getInstance(Map predicatesAndClosures) {
        if (predicatesAndClosures == null) {
            throw new IllegalArgumentException("The predicate and closure map must not be null");
        }
        if (predicatesAndClosures.size() == 0) {
            return NOPClosure.INSTANCE;
        }
        Closure closure = (Closure)predicatesAndClosures.remove(null);
        int n2 = predicatesAndClosures.size();
        if (n2 == 0) {
            if (closure == null) {
                return NOPClosure.INSTANCE;
            }
            return closure;
        }
        Closure[] closures = new Closure[n2];
        Predicate[] preds = new Predicate[n2];
        int n3 = 0;
        Iterator iterator = predicatesAndClosures.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            preds[n3] = (Predicate)entry.getKey();
            closures[n3] = (Closure)entry.getValue();
            ++n3;
        }
        return new SwitchClosure(preds, closures, closure);
    }

    public SwitchClosure(Predicate[] predicates, Closure[] closures, Closure defaultClosure) {
        this.iPredicates = predicates;
        this.iClosures = closures;
        this.iDefault = defaultClosure == null ? NOPClosure.INSTANCE : defaultClosure;
    }

    public void execute(Object input) {
        for (int i2 = 0; i2 < this.iPredicates.length; ++i2) {
            if (!this.iPredicates[i2].evaluate(input)) continue;
            this.iClosures[i2].execute(input);
            return;
        }
        this.iDefault.execute(input);
    }

    public Predicate[] getPredicates() {
        return this.iPredicates;
    }

    public Closure[] getClosures() {
        return this.iClosures;
    }

    public Closure getDefaultClosure() {
        return this.iDefault;
    }
}

