/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.commons.collections.set.CompositeSet;

public class CompositeMap
implements Map {
    private Map[] composite;
    private MapMutator mutator;

    public CompositeMap() {
        this(new Map[0], null);
    }

    public CompositeMap(Map one, Map two) {
        this(new Map[]{one, two}, null);
    }

    public CompositeMap(Map one, Map two, MapMutator mutator) {
        this(new Map[]{one, two}, mutator);
    }

    public CompositeMap(Map[] composite) {
        this(composite, null);
    }

    public CompositeMap(Map[] composite, MapMutator mutator) {
        this.mutator = mutator;
        this.composite = new Map[0];
        for (int i2 = composite.length - 1; i2 >= 0; --i2) {
            this.addComposited(composite[i2]);
        }
    }

    public void setMutator(MapMutator mutator) {
        this.mutator = mutator;
    }

    public synchronized void addComposited(Map map) throws IllegalArgumentException {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            Collection collection = CollectionUtils.intersection(this.composite[i2].keySet(), map.keySet());
            if (collection.size() == 0) continue;
            if (this.mutator == null) {
                throw new IllegalArgumentException("Key collision adding Map to CompositeMap");
            }
            CompositeMap compositeMap = this;
            this.mutator.resolveCollision(compositeMap, compositeMap.composite[i2], map, collection);
        }
        Map[] mapArray = new Map[this.composite.length + 1];
        System.arraycopy(this.composite, 0, mapArray, 0, this.composite.length);
        mapArray[mapArray.length - 1] = map;
        this.composite = mapArray;
    }

    public synchronized Map removeComposited(Map map) {
        int n2 = this.composite.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.composite[i2].equals(map)) continue;
            Map[] mapArray = new Map[n2 - 1];
            System.arraycopy(this.composite, 0, mapArray, 0, i2);
            System.arraycopy(this.composite, i2 + 1, mapArray, i2, n2 - i2 - 1);
            this.composite = mapArray;
            return map;
        }
        return null;
    }

    public void clear() {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            this.composite[i2].clear();
        }
    }

    public boolean containsKey(Object key) {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (!this.composite[i2].containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (!this.composite[i2].containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        CompositeSet compositeSet = new CompositeSet();
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            compositeSet.addComposited(this.composite[i2].entrySet());
        }
        return compositeSet;
    }

    public Object get(Object key) {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (!this.composite[i2].containsKey(key)) continue;
            return this.composite[i2].get(key);
        }
        return null;
    }

    public boolean isEmpty() {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (this.composite[i2].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set keySet() {
        CompositeSet compositeSet = new CompositeSet();
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            compositeSet.addComposited(this.composite[i2].keySet());
        }
        return compositeSet;
    }

    public Object put(Object key, Object value) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        CompositeMap compositeMap = this;
        return this.mutator.put(compositeMap, compositeMap.composite, key, value);
    }

    public void putAll(Map map) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        CompositeMap compositeMap = this;
        this.mutator.putAll(compositeMap, compositeMap.composite, map);
    }

    public Object remove(Object key) {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (!this.composite[i2].containsKey(key)) continue;
            return this.composite[i2].remove(key);
        }
        return null;
    }

    public int size() {
        int n2 = 0;
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            n2 += this.composite[i2].size();
        }
        return n2;
    }

    public Collection values() {
        CompositeCollection compositeCollection = new CompositeCollection();
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            compositeCollection.addComposited(this.composite[i2].values());
        }
        return compositeCollection;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n2 += iterator.next().hashCode();
        }
        return n2;
    }

    public static interface MapMutator {
        public void resolveCollision(CompositeMap var1, Map var2, Map var3, Collection var4);

        public Object put(CompositeMap var1, Map[] var2, Object var3, Object var4);

        public void putAll(CompositeMap var1, Map[] var2, Map var3);
    }
}

