/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.text.StrBuilder;

public class ObjectUtils {
    public static final Null NULL = new Null();

    public static <T> T defaultIfNull(T object, T defaultValue) {
        if (object != null) {
            return object;
        }
        return defaultValue;
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... values) {
        if (values != null) {
            T[] TArray = values;
            int n2 = values.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                T t2 = TArray[i2];
                if (t2 == null) continue;
                return t2;
            }
        }
        return null;
    }

    public static boolean anyNotNull(Object ... values) {
        return ObjectUtils.firstNonNull(values) != null;
    }

    public static boolean allNotNull(Object ... values) {
        if (values == null) {
            return false;
        }
        Object[] objectArray = values;
        int n2 = values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (object != null) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static boolean notEqual(Object object1, Object object2) {
        return !ObjectUtils.equals(object1, object2);
    }

    @Deprecated
    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    @Deprecated
    public static int hashCodeMulti(Object ... objects) {
        int n2 = 1;
        if (objects != null) {
            Object[] objectArray = objects;
            int n3 = objects.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = objectArray[i2];
                int n4 = ObjectUtils.hashCode(object);
                n2 = n2 * 31 + n4;
            }
        }
        return n2;
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ObjectUtils.identityToString(stringBuilder, object);
        return stringBuilder.toString();
    }

    public static void identityToString(Appendable appendable, Object object) throws IOException {
        Validate.notNull(object, "Cannot get the toString of a null identity", new Object[0]);
        appendable.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    @Deprecated
    public static void identityToString(StrBuilder builder, Object object) {
        Validate.notNull(object, "Cannot get the toString of a null identity", new Object[0]);
        builder.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static void identityToString(StringBuffer buffer, Object object) {
        Validate.notNull(object, "Cannot get the toString of a null identity", new Object[0]);
        buffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static void identityToString(StringBuilder builder, Object object) {
        Validate.notNull(object, "Cannot get the toString of a null identity", new Object[0]);
        builder.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    @Deprecated
    public static String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    @Deprecated
    public static String toString(Object obj, String nullStr) {
        if (obj == null) {
            return nullStr;
        }
        return obj.toString();
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T min(T ... values) {
        T t2 = null;
        if (values != null) {
            T[] TArray = values;
            int n2 = values.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                T t3 = TArray[i2];
                if (ObjectUtils.compare(t3, t2, true) >= 0) continue;
                t2 = t3;
            }
        }
        return t2;
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T max(T ... values) {
        T t2 = null;
        if (values != null) {
            T[] TArray = values;
            int n2 = values.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                T t3 = TArray[i2];
                if (ObjectUtils.compare(t3, t2, false) <= 0) continue;
                t2 = t3;
            }
        }
        return t2;
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        return ObjectUtils.compare(c1, c2, false);
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean nullGreater) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            if (nullGreater) {
                return 1;
            }
            return -1;
        }
        if (c2 == null) {
            if (nullGreater) {
                return -1;
            }
            return 1;
        }
        return c1.compareTo(c2);
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T median(T ... items) {
        Validate.notEmpty(items);
        Validate.noNullElements(items);
        TreeSet treeSet = new TreeSet();
        Collections.addAll(treeSet, items);
        Comparable comparable = (Comparable)treeSet.toArray()[(treeSet.size() - 1) / 2];
        return (T)comparable;
    }

    @SafeVarargs
    public static <T> T median(Comparator<T> comparator, T ... items) {
        Validate.notEmpty(items, "null/empty items", new Object[0]);
        Validate.noNullElements(items);
        Validate.notNull(comparator, "null comparator", new Object[0]);
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        Collections.addAll(treeSet, items);
        Object object = treeSet.toArray()[(treeSet.size() - 1) / 2];
        return (T)object;
    }

    @SafeVarargs
    public static <T> T mode(T ... items) {
        if (ArrayUtils.isNotEmpty(items)) {
            HashMap<T, MutableInt> hashMap = new HashMap<T, MutableInt>(items.length);
            Object object = items;
            int n2 = items.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                T object2 = object[i2];
                MutableInt mutableInt = (MutableInt)hashMap.get(object2);
                if (mutableInt == null) {
                    hashMap.put(object2, new MutableInt(1));
                    continue;
                }
                mutableInt.increment();
            }
            object = null;
            n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                int n3 = ((MutableInt)entry.getValue()).intValue();
                if (n3 == n2) {
                    object = null;
                    continue;
                }
                if (n3 <= n2) continue;
                n2 = n3;
                object = entry.getKey();
            }
            return (T)object;
        }
        return null;
    }

    public static <T> T clone(T obj) {
        if (obj instanceof Cloneable) {
            Object object;
            Class<?> clazz;
            if (obj.getClass().isArray()) {
                clazz = obj.getClass().getComponentType();
                if (!clazz.isPrimitive()) {
                    object = ((Object[])obj).clone();
                } else {
                    int n2 = Array.getLength(obj);
                    object = Array.newInstance(clazz, n2);
                    while (n2-- > 0) {
                        Array.set(object, n2, Array.get(obj, n2));
                    }
                }
            } else {
                try {
                    clazz = obj.getClass().getMethod("clone", new Class[0]);
                    object = ((Method)((Object)clazz)).invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new CloneFailedException("Cloneable type " + obj.getClass().getName() + " has no clone method", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CloneFailedException("Cannot clone Cloneable type " + obj.getClass().getName(), illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new CloneFailedException("Exception cloning Cloneable type " + obj.getClass().getName(), invocationTargetException.getCause());
                }
            }
            clazz = object;
            return (T)clazz;
        }
        return null;
    }

    public static <T> T cloneIfPossible(T obj) {
        T t2 = ObjectUtils.clone(obj);
        if (t2 == null) {
            return obj;
        }
        return t2;
    }

    public static boolean CONST(boolean v2) {
        return v2;
    }

    public static byte CONST(byte v2) {
        return v2;
    }

    public static byte CONST_BYTE(int v2) throws IllegalArgumentException {
        if (v2 < -128 || v2 > 127) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -128 and 127: [" + v2 + "]");
        }
        return (byte)v2;
    }

    public static char CONST(char v2) {
        return v2;
    }

    public static short CONST(short v2) {
        return v2;
    }

    public static short CONST_SHORT(int v2) throws IllegalArgumentException {
        if (v2 < Short.MIN_VALUE || v2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -32768 and 32767: [" + v2 + "]");
        }
        return (short)v2;
    }

    public static int CONST(int v2) {
        return v2;
    }

    public static long CONST(long v2) {
        return v2;
    }

    public static float CONST(float v2) {
        return v2;
    }

    public static double CONST(double v2) {
        return v2;
    }

    public static <T> T CONST(T v2) {
        return v2;
    }

    public static class Null
    implements Serializable {
        private static final long serialVersionUID = 7092611880189329093L;

        Null() {
        }

        private Object readResolve() {
            return NULL;
        }
    }
}

