/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ConstructorUtils {
    public static <T> T invokeConstructor(Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] classArray = ClassUtils.toClass(args);
        return ConstructorUtils.invokeConstructor(cls, args, classArray);
    }

    public static <T> T invokeConstructor(Class<T> cls, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        args = ArrayUtils.nullToEmpty(args);
        Constructor<T> constructor = ConstructorUtils.getMatchingAccessibleConstructor(cls, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (constructor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + cls.getName());
        }
        if (constructor.isVarArgs()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            args = MethodUtils.getVarArgs(args, classArray);
        }
        return constructor.newInstance(args);
    }

    public static <T> T invokeExactConstructor(Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] classArray = ClassUtils.toClass(args);
        return ConstructorUtils.invokeExactConstructor(cls, args, classArray);
    }

    public static <T> T invokeExactConstructor(Class<T> cls, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        args = ArrayUtils.nullToEmpty(args);
        Constructor<T> constructor = ConstructorUtils.getAccessibleConstructor(cls, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (constructor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + cls.getName());
        }
        return constructor.newInstance(args);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Validate.notNull(cls, "class cannot be null", new Object[0]);
        try {
            return ConstructorUtils.getAccessibleConstructor(cls.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> ctor) {
        Validate.notNull(ctor, "constructor cannot be null", new Object[0]);
        if (MemberUtils.isAccessible(ctor) && ConstructorUtils.isAccessible(ctor.getDeclaringClass())) {
            return ctor;
        }
        return null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Validate.notNull(cls, "class cannot be null", new Object[0]);
        try {
            Constructor<T> constructor = cls.getConstructor(parameterTypes);
            MemberUtils.setAccessibleWorkaround(constructor);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?>[] constructorArray;
            Constructor<?> constructor = null;
            Constructor<?>[] constructorArray2 = constructorArray = cls.getConstructors();
            int n2 = constructorArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Constructor<?> constructor2;
                Constructor<?> constructor3 = constructorArray2[i2];
                if (!MemberUtils.isMatchingConstructor(constructor3, parameterTypes) || (constructor3 = ConstructorUtils.getAccessibleConstructor(constructor3)) == null) continue;
                MemberUtils.setAccessibleWorkaround(constructor3);
                if (constructor != null && MemberUtils.compareConstructorFit(constructor3, constructor, parameterTypes) >= 0) continue;
                constructor = constructor2 = constructor3;
            }
            return constructor;
        }
    }

    private static boolean isAccessible(Class<?> type) {
        for (Class<?> clazz = type; clazz != null; clazz = clazz.getEnclosingClass()) {
            if (Modifier.isPublic(clazz.getModifiers())) continue;
            return false;
        }
        return true;
    }
}

