/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.LevenshteinResults;

public class LevenshteinDetailedDistance
implements EditDistance<LevenshteinResults> {
    private static final LevenshteinDetailedDistance DEFAULT_INSTANCE = new LevenshteinDetailedDistance();
    private final Integer threshold;

    public LevenshteinDetailedDistance() {
        this(null);
    }

    public LevenshteinDetailedDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public LevenshteinResults apply(CharSequence left, CharSequence right) {
        if (this.threshold != null) {
            return LevenshteinDetailedDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDetailedDistance.unlimitedCompare(left, right);
    }

    public static LevenshteinDetailedDistance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    private static LevenshteinResults limitedCompare(CharSequence left, CharSequence right, int threshold) {
        Object object;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n2 = left.length();
        int n3 = right.length();
        if (n2 == 0) {
            if (n3 <= threshold) {
                return new LevenshteinResults(n3, n3, 0, 0);
            }
            return new LevenshteinResults(-1, 0, 0, 0);
        }
        if (n3 == 0) {
            if (n2 <= threshold) {
                return new LevenshteinResults(n2, 0, n2, 0);
            }
            return new LevenshteinResults(-1, 0, 0, 0);
        }
        boolean bl = false;
        if (n2 > n3) {
            object = left;
            left = right;
            right = object;
            n2 = n3;
            n3 = right.length();
            bl = true;
        }
        object = new int[n2 + 1];
        Object object2 = new int[n2 + 1];
        int[][] nArray = new int[n3 + 1][n2 + 1];
        int n4 = 0;
        while (n4 <= n2) {
            int n5 = n4++;
            nArray[0][n5] = n5;
        }
        for (n4 = 0; n4 <= n3; ++n4) {
            nArray[n4][0] = n4;
        }
        n4 = Math.min(n2, threshold) + 1;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = n6++;
            object[n7] = n7;
        }
        Arrays.fill((int[])object, n4, ((Object)object).length, Integer.MAX_VALUE);
        Arrays.fill(object2, Integer.MAX_VALUE);
        for (n6 = 1; n6 <= n3; ++n6) {
            int n8;
            char c2 = right.charAt(n6 - 1);
            object2[0] = n6;
            int n9 = Math.max(1, n6 - threshold);
            int n10 = n8 = n6 > Integer.MAX_VALUE - threshold ? n2 : Math.min(n2, n6 + threshold);
            if (n9 > n8) {
                return new LevenshteinResults(-1, 0, 0, 0);
            }
            if (n9 > 1) {
                object2[n9 - 1] = Integer.MAX_VALUE;
            }
            for (int i2 = n9; i2 <= n8; ++i2) {
                object2[i2] = left.charAt(i2 - 1) == c2 ? (int)object[i2 - 1] : 1 + Math.min(Math.min(object2[i2 - 1], (int)object[i2]), (int)object[i2 - 1]);
                nArray[n6][i2] = object2[i2];
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        if (object[n2] <= threshold) {
            return LevenshteinDetailedDistance.findDetailedResults(left, right, nArray, bl);
        }
        return new LevenshteinResults(-1, 0, 0, 0);
    }

    private static LevenshteinResults unlimitedCompare(CharSequence left, CharSequence right) {
        Object object;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = left.length();
        int n3 = right.length();
        if (n2 == 0) {
            return new LevenshteinResults(n3, n3, 0, 0);
        }
        if (n3 == 0) {
            return new LevenshteinResults(n2, 0, n2, 0);
        }
        boolean bl = false;
        if (n2 > n3) {
            object = left;
            left = right;
            right = object;
            n2 = n3;
            n3 = right.length();
            bl = true;
        }
        object = new int[n2 + 1];
        Object object2 = new int[n2 + 1];
        int[][] nArray = new int[n3 + 1][n2 + 1];
        int n4 = 0;
        while (n4 <= n2) {
            int n5 = n4++;
            nArray[0][n5] = n5;
        }
        for (n4 = 0; n4 <= n3; ++n4) {
            nArray[n4][0] = n4;
        }
        n4 = 0;
        while (n4 <= n2) {
            int n6 = n4++;
            object[n6] = n6;
        }
        for (int i2 = 1; i2 <= n3; ++i2) {
            char c2 = right.charAt(i2 - 1);
            object2[0] = i2;
            for (n4 = 1; n4 <= n2; ++n4) {
                boolean bl2 = left.charAt(n4 - 1) != c2;
                object2[n4] = Math.min(Math.min(object2[n4 - 1] + 1, (int)(object[n4] + true)), (int)(object[n4 - 1] + bl2));
                nArray[i2][n4] = object2[n4];
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        return LevenshteinDetailedDistance.findDetailedResults(left, right, nArray, bl);
    }

    /*
     * Unable to fully structure code
     */
    private static LevenshteinResults findDetailedResults(CharSequence left, CharSequence right, int[][] matrix, boolean swapped) {
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = right.length();
        var8_8 = left.length();
        while (var7_7 >= 0 && var8_8 >= 0) {
            block6: {
                block5: {
                    var9_9 = var8_8 == 0 ? -1 : matrix[var7_7][var8_8 - 1];
                    var10_10 = var7_7 == 0 ? -1 : matrix[var7_7 - 1][var8_8];
                    var11_11 = var7_7 > 0 && var8_8 > 0 ? matrix[var7_7 - 1][var8_8 - 1] : -1;
                    if (var9_9 == -1 && var10_10 == -1 && var11_11 == -1) break;
                    var12_12 = matrix[var7_7][var8_8];
                    if (var8_8 > 0 && var7_7 > 0 && left.charAt(var8_8 - 1) == right.charAt(var7_7 - 1)) {
                        --var8_8;
                        --var7_7;
                        continue;
                    }
                    var13_13 = false;
                    var14_14 = false;
                    if ((var12_12 - 1 != var9_9 || var12_12 > var11_11 || var12_12 > var10_10) && (var11_11 != -1 || var10_10 != -1)) break block5;
                    --var8_8;
                    if (swapped) ** GOTO lbl-1000
                    ++var4_4;
                    var13_13 = true;
                    break block6;
                }
                if (var12_12 - 1 == var10_10 && var12_12 <= var11_11 && var12_12 <= var9_9 || var11_11 == -1 && var9_9 == -1) {
                    --var7_7;
                    ** if (!swapped) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        ++var4_4;
                        var13_13 = true;
                        ** GOTO lbl34
                    }
                }
                break block6;
lbl-1000:
                // 2 sources

                {
                    ++var5_5;
                    var14_14 = true;
                }
            }
            if (var14_14 || var13_13) continue;
            ++var6_6;
            --var8_8;
            --var7_7;
        }
        return new LevenshteinResults(var5_5 + var4_4 + var6_6, var5_5, var4_4, var6_6);
    }
}

