/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.capnproto.BufferedInputStream;

public final class PackedInputStream
implements ReadableByteChannel {
    final BufferedInputStream inner;

    public PackedInputStream(BufferedInputStream bufferedInputStream) {
        this.inner = bufferedInputStream;
    }

    @Override
    public final int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return 0;
        }
        if (n2 % 8 != 0) {
            throw new Error("PackedInputStream reads must be word-aligned");
        }
        int n3 = byteBuffer.position();
        int n4 = n3 + n2;
        ByteBuffer byteBuffer2 = this.inner.getReadBuffer();
        while (true) {
            int n5;
            int n6;
            byte by;
            if (byteBuffer2.remaining() < 10) {
                if (byteBuffer.remaining() == 0) {
                    return n2;
                }
                if (byteBuffer2.remaining() == 0) {
                    byteBuffer2 = this.inner.getReadBuffer();
                    continue;
                }
                by = byteBuffer2.get();
                for (n6 = 0; n6 < 8; ++n6) {
                    if ((by & 1 << n6) != 0) {
                        if (byteBuffer2.remaining() == 0) {
                            byteBuffer2 = this.inner.getReadBuffer();
                        }
                        byteBuffer.put(byteBuffer2.get());
                        continue;
                    }
                    byteBuffer.put((byte)0);
                }
                if (byteBuffer2.remaining() == 0 && (by == 0 || by == -1)) {
                    byteBuffer2 = this.inner.getReadBuffer();
                }
            } else {
                by = byteBuffer2.get();
                for (n6 = 0; n6 < 8; ++n6) {
                    n5 = (by & 1 << n6) != 0 ? 1 : 0;
                    byteBuffer.put((byte)(byteBuffer2.get() & (n5 != 0 ? -1 : 0)));
                    ByteBuffer byteBuffer3 = byteBuffer2;
                    byteBuffer3.position(byteBuffer3.position() + (n5 != 0 ? 0 : -1));
                }
            }
            if (by == 0) {
                if (byteBuffer2.remaining() == 0) {
                    throw new Error("Should always have non-empty buffer here.");
                }
                n6 = (0xFF & byteBuffer2.get()) << 3;
                if (n6 > n4 - n3) {
                    throw new Error("Packed input did not end cleanly on a segment boundary");
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    byteBuffer.put((byte)0);
                }
            } else if (by == -1) {
                n6 = (0xFF & byteBuffer2.get()) << 3;
                if (byteBuffer2.remaining() >= n6) {
                    ByteBuffer byteBuffer4 = byteBuffer2.slice();
                    byteBuffer4.limit(n6);
                    byteBuffer.put(byteBuffer4);
                    ByteBuffer byteBuffer5 = byteBuffer2;
                    byteBuffer5.position(byteBuffer5.position() + n6);
                } else {
                    byteBuffer.put(byteBuffer2);
                    ByteBuffer byteBuffer6 = byteBuffer.slice();
                    byteBuffer6.limit(n6 -= byteBuffer2.remaining());
                    this.inner.read(byteBuffer6);
                    ByteBuffer byteBuffer7 = byteBuffer;
                    byteBuffer7.position(byteBuffer7.position() + n6);
                    if (byteBuffer.remaining() == 0) {
                        return n2;
                    }
                    byteBuffer2 = this.inner.getReadBuffer();
                    continue;
                }
            }
            if (byteBuffer.remaining() == 0) break;
        }
        return n2;
    }

    @Override
    public final void close() throws IOException {
        this.inner.close();
    }

    @Override
    public final boolean isOpen() {
        return this.inner.isOpen();
    }
}

