/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.capnproto.DecodeException;
import org.capnproto.MessageBuilder;
import org.capnproto.MessageReader;
import org.capnproto.ReaderOptions;

public final class Serialize {
    static ByteBuffer makeByteBuffer(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.mark();
        return byteBuffer;
    }

    public static void fillBuffer(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel) throws IOException {
        while (byteBuffer.hasRemaining()) {
            int n2 = readableByteChannel.read(byteBuffer);
            if (n2 >= 0) continue;
            throw new IOException("premature EOF");
        }
    }

    public static MessageReader read(ReadableByteChannel readableByteChannel) throws IOException {
        return Serialize.read(readableByteChannel, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(ReadableByteChannel readableByteChannel, ReaderOptions readerOptions) throws IOException {
        int n2;
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = Serialize.makeByteBuffer(8);
        Serialize.fillBuffer(byteBuffer2, readableByteChannel);
        int n3 = 1 + byteBuffer2.getInt(0);
        int n4 = 0;
        if (n3 > 0) {
            n4 = byteBuffer2.getInt(4);
        }
        int n5 = n4;
        if (n3 > 512) {
            throw new IOException("too many segments");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n3 > 1) {
            byteBuffer = Serialize.makeByteBuffer(4 * (n3 & 0xFFFFFFFE));
            Serialize.fillBuffer(byteBuffer, readableByteChannel);
            for (int i2 = 0; i2 < n3 - 1; ++i2) {
                n2 = byteBuffer.getInt(i2 << 2);
                arrayList.add(n2);
                n5 += n2;
            }
        }
        if ((long)n5 > readerOptions.traversalLimitInWords) {
            throw new DecodeException("Message size exceeds traversal limit.");
        }
        byteBuffer = Serialize.makeByteBuffer(n5 << 3);
        Serialize.fillBuffer(byteBuffer, readableByteChannel);
        ByteBuffer[] byteBufferArray = new ByteBuffer[n3];
        byteBuffer.rewind();
        byteBufferArray[0] = byteBuffer.slice();
        byteBufferArray[0].limit(n4 << 3);
        byteBufferArray[0].order(ByteOrder.LITTLE_ENDIAN);
        n2 = n4;
        for (int i3 = 1; i3 < n3; ++i3) {
            byteBuffer.position(n2 << 3);
            byteBufferArray[i3] = byteBuffer.slice();
            byteBufferArray[i3].limit((Integer)arrayList.get(i3 - 1) << 3);
            byteBufferArray[i3].order(ByteOrder.LITTLE_ENDIAN);
            n2 += ((Integer)arrayList.get(i3 - 1)).intValue();
        }
        return new MessageReader(byteBufferArray, readerOptions);
    }

    public static MessageReader read(ByteBuffer byteBuffer) throws IOException {
        return Serialize.read(byteBuffer, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(ByteBuffer byteBuffer, ReaderOptions readerOptions) throws IOException {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n2 = 1 + byteBuffer.getInt();
        if (n2 > 512) {
            throw new IOException("too many segments");
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[n2];
        int n3 = byteBuffer.position();
        int n4 = n2 << 2;
        int n5 = n3 + n4 + 7 & 0xFFFFFFF8;
        int n6 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n7 = byteBuffer.getInt(n3 + (i2 << 2));
            byteBuffer.position(n5 + (n6 << 3));
            byteBufferArray[i2] = byteBuffer.slice();
            byteBufferArray[i2].limit(n7 << 3);
            byteBufferArray[i2].order(ByteOrder.LITTLE_ENDIAN);
            n6 += n7;
        }
        byteBuffer.position(n5 + (n6 << 3));
        if ((long)n6 > readerOptions.traversalLimitInWords) {
            throw new DecodeException("Message size exceeds traversal limit.");
        }
        return new MessageReader(byteBufferArray, readerOptions);
    }

    public static long computeSerializedSizeInWords(MessageBuilder messageBuilder) {
        ByteBuffer[] byteBufferArray = messageBuilder.getSegmentsForOutput();
        long l2 = 4L + (long)(byteBufferArray.length << 2);
        if (l2 % 8L != 0L) {
            l2 += 4L;
        }
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            ByteBuffer byteBuffer = byteBufferArray[i2];
            l2 += (long)byteBuffer.limit();
        }
        return l2 / 8L;
    }

    public static void write(WritableByteChannel writableByteChannel, MessageBuilder messageBuilder) throws IOException {
        ByteBuffer[] byteBufferArray = messageBuilder.getSegmentsForOutput();
        int n2 = byteBufferArray.length + 2 & 0xFFFFFFFE;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(0, byteBufferArray.length - 1);
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            byteBuffer.putInt(4 * (i2 + 1), byteBufferArray[i2].limit() / 8);
        }
        while (byteBuffer.hasRemaining()) {
            writableByteChannel.write(byteBuffer);
        }
        ByteBuffer[] byteBufferArray2 = byteBufferArray;
        int n3 = byteBufferArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            ByteBuffer byteBuffer2 = byteBufferArray2[i3];
            while (byteBuffer2.hasRemaining()) {
                writableByteChannel.write(byteBuffer2);
            }
        }
    }
}

