/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.MutableInterval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractInterval
implements ReadableInterval {
    protected AbstractInterval() {
    }

    protected void checkInterval(long l2, long l3) {
        if (l3 < l2) {
            throw new IllegalArgumentException("The end instant must be greater than the start instant");
        }
    }

    public DateTime getStart() {
        return new DateTime(this.getStartMillis(), this.getChronology());
    }

    public DateTime getEnd() {
        return new DateTime(this.getEndMillis(), this.getChronology());
    }

    public boolean contains(long l2) {
        long l3 = this.getStartMillis();
        long l4 = this.getEndMillis();
        return l2 >= l3 && l2 < l4;
    }

    public boolean containsNow() {
        return this.contains(DateTimeUtils.currentTimeMillis());
    }

    public boolean contains(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.containsNow();
        }
        return this.contains(readableInstant.getMillis());
    }

    public boolean contains(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return this.containsNow();
        }
        long l2 = readableInterval.getStartMillis();
        long l3 = readableInterval.getEndMillis();
        long l4 = this.getStartMillis();
        long l5 = this.getEndMillis();
        return l4 <= l2 && l2 < l5 && l3 <= l5;
    }

    public boolean overlaps(ReadableInterval readableInterval) {
        long l2 = this.getStartMillis();
        long l3 = this.getEndMillis();
        if (readableInterval == null) {
            long l4 = DateTimeUtils.currentTimeMillis();
            return l2 < l4 && l4 < l3;
        }
        long l5 = readableInterval.getStartMillis();
        long l6 = readableInterval.getEndMillis();
        return l2 < l6 && l5 < l3;
    }

    public boolean isEqual(ReadableInterval readableInterval) {
        return this.getStartMillis() == readableInterval.getStartMillis() && this.getEndMillis() == readableInterval.getEndMillis();
    }

    public boolean isBefore(long l2) {
        return this.getEndMillis() <= l2;
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    public boolean isBefore(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(readableInstant.getMillis());
    }

    public boolean isBefore(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(readableInterval.getStartMillis());
    }

    public boolean isAfter(long l2) {
        return this.getStartMillis() > l2;
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    public boolean isAfter(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.isAfterNow();
        }
        return this.isAfter(readableInstant.getMillis());
    }

    public boolean isAfter(ReadableInterval readableInterval) {
        long l2 = readableInterval == null ? DateTimeUtils.currentTimeMillis() : readableInterval.getEndMillis();
        return this.getStartMillis() >= l2;
    }

    public Interval toInterval() {
        return new Interval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    public MutableInterval toMutableInterval() {
        return new MutableInterval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    public long toDurationMillis() {
        return FieldUtils.safeSubtract(this.getEndMillis(), this.getStartMillis());
    }

    public Duration toDuration() {
        long l2 = this.toDurationMillis();
        if (l2 == 0L) {
            return Duration.ZERO;
        }
        return new Duration(l2);
    }

    public Period toPeriod() {
        return new Period(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    public Period toPeriod(PeriodType periodType) {
        return new Period(this.getStartMillis(), this.getEndMillis(), periodType, this.getChronology());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReadableInterval)) {
            return false;
        }
        ReadableInterval readableInterval = (ReadableInterval)object;
        return this.getStartMillis() == readableInterval.getStartMillis() && this.getEndMillis() == readableInterval.getEndMillis() && FieldUtils.equals(this.getChronology(), readableInterval.getChronology());
    }

    public int hashCode() {
        long l2 = this.getStartMillis();
        long l3 = this.getEndMillis();
        long l4 = l2;
        int n2 = 3007 + (int)(l4 ^ l4 >>> 32);
        long l5 = l3;
        n2 = n2 * 31 + (int)(l5 ^ l5 >>> 32);
        n2 = n2 * 31 + this.getChronology().hashCode();
        return n2;
    }

    public String toString() {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
        dateTimeFormatter = dateTimeFormatter.withChronology(this.getChronology());
        StringBuffer stringBuffer = new StringBuffer(48);
        dateTimeFormatter.printTo(stringBuffer, this.getStartMillis());
        stringBuffer.append('/');
        dateTimeFormatter.printTo(stringBuffer, this.getEndMillis());
        return stringBuffer.toString();
    }
}

