/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Mfcc
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> output;

    public static Mfcc create(Scope scope, Operand<Float> spectrogram, Operand<Integer> sampleRate, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Mfcc", scope.makeOpName("Mfcc"));
        operationBuilder.addInput(spectrogram.asOutput());
        operationBuilder.addInput(sampleRate.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.upperFrequencyLimit != null) {
                    operationBuilder.setAttr("upper_frequency_limit", options2.upperFrequencyLimit.floatValue());
                }
                if (options2.lowerFrequencyLimit != null) {
                    operationBuilder.setAttr("lower_frequency_limit", options2.lowerFrequencyLimit.floatValue());
                }
                if (options2.filterbankChannelCount != null) {
                    operationBuilder.setAttr("filterbank_channel_count", options2.filterbankChannelCount);
                }
                if (options2.dctCoefficientCount == null) continue;
                operationBuilder.setAttr("dct_coefficient_count", options2.dctCoefficientCount);
            }
        }
        return new Mfcc(operationBuilder.build());
    }

    public static Options upperFrequencyLimit(Float upperFrequencyLimit) {
        return new Options().upperFrequencyLimit(upperFrequencyLimit);
    }

    public static Options lowerFrequencyLimit(Float lowerFrequencyLimit) {
        return new Options().lowerFrequencyLimit(lowerFrequencyLimit);
    }

    public static Options filterbankChannelCount(Long filterbankChannelCount) {
        return new Options().filterbankChannelCount(filterbankChannelCount);
    }

    public static Options dctCoefficientCount(Long dctCoefficientCount) {
        return new Options().dctCoefficientCount(dctCoefficientCount);
    }

    public final Output<Float> output() {
        return this.output;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.output;
    }

    private Mfcc(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Float upperFrequencyLimit;
        private Float lowerFrequencyLimit;
        private Long filterbankChannelCount;
        private Long dctCoefficientCount;

        public Options upperFrequencyLimit(Float upperFrequencyLimit) {
            this.upperFrequencyLimit = upperFrequencyLimit;
            return this;
        }

        public Options lowerFrequencyLimit(Float lowerFrequencyLimit) {
            this.lowerFrequencyLimit = lowerFrequencyLimit;
            return this;
        }

        public Options filterbankChannelCount(Long filterbankChannelCount) {
            this.filterbankChannelCount = filterbankChannelCount;
            return this;
        }

        public Options dctCoefficientCount(Long dctCoefficientCount) {
            this.dctCoefficientCount = dctCoefficientCount;
            return this;
        }

        private Options() {
        }
    }
}

