/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizeAndDequantizeV3<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> QuantizeAndDequantizeV3<T> create(Scope scope, Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Operand<Integer> numBits, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizeAndDequantizeV3", scope.makeOpName("QuantizeAndDequantizeV3"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(inputMin.asOutput());
        operationBuilder.addInput(inputMax.asOutput());
        operationBuilder.addInput(numBits.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.signedInput != null) {
                    operationBuilder.setAttr("signed_input", options2.signedInput);
                }
                if (options2.rangeGiven == null) continue;
                operationBuilder.setAttr("range_given", options2.rangeGiven);
            }
        }
        return new QuantizeAndDequantizeV3<T>(operationBuilder.build());
    }

    public static Options signedInput(Boolean signedInput) {
        return new Options().signedInput(signedInput);
    }

    public static Options rangeGiven(Boolean rangeGiven) {
        return new Options().rangeGiven(rangeGiven);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private QuantizeAndDequantizeV3(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean signedInput;
        private Boolean rangeGiven;

        public Options signedInput(Boolean signedInput) {
            this.signedInput = signedInput;
            return this;
        }

        public Options rangeGiven(Boolean rangeGiven) {
            this.rangeGiven = rangeGiven;
            return this;
        }

        private Options() {
        }
    }
}

