/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizeV2<T>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Float> outputMin;
    private Output<Float> outputMax;

    public static <T> QuantizeV2<T> create(Scope scope, Operand<Float> input, Operand<Float> minRange, Operand<Float> maxRange, Class<T> T, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizeV2", scope.makeOpName("QuantizeV2"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(minRange.asOutput());
        operationBuilder.addInput(maxRange.asOutput());
        operationBuilder.setAttr("T", DataType.fromClass(T));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.mode != null) {
                    operationBuilder.setAttr("mode", options2.mode);
                }
                if (options2.roundMode == null) continue;
                operationBuilder.setAttr("round_mode", options2.roundMode);
            }
        }
        return new QuantizeV2<T>(operationBuilder.build());
    }

    public static Options mode(String mode) {
        return new Options().mode(mode);
    }

    public static Options roundMode(String roundMode) {
        return new Options().roundMode(roundMode);
    }

    public final Output<T> output() {
        return this.output;
    }

    public final Output<Float> outputMin() {
        return this.outputMin;
    }

    public final Output<Float> outputMax() {
        return this.outputMax;
    }

    private QuantizeV2(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.outputMin = operation.output(1);
        this.outputMax = operation.output(2);
    }

    public static class Options {
        private String mode;
        private String roundMode;

        public Options mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Options roundMode(String roundMode) {
            this.roundMode = roundMode;
            return this;
        }

        private Options() {
        }
    }
}

