/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResizeNearestNeighbor<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> resizedImages;

    public static <T extends Number> ResizeNearestNeighbor<T> create(Scope scope, Operand<T> images, Operand<Integer> size, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ResizeNearestNeighbor", scope.makeOpName("ResizeNearestNeighbor"));
        operationBuilder.addInput(images.asOutput());
        operationBuilder.addInput(size.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.alignCorners == null) continue;
                operationBuilder.setAttr("align_corners", options2.alignCorners);
            }
        }
        return new ResizeNearestNeighbor<T>(operationBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public final Output<T> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public final Output<T> asOutput() {
        return this.resizedImages;
    }

    private ResizeNearestNeighbor(Operation operation) {
        super(operation);
        this.resizedImages = operation.output(0);
    }

    public static class Options {
        private Boolean alignCorners;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        private Options() {
        }
    }
}

