/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RestoreV2
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> tensors;

    public static RestoreV2 create(Scope scope, Operand<String> prefix, Operand<String> tensorNames, Operand<String> shapeAndSlices, List<Class<?>> dtypes) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("RestoreV2", scope.makeOpName("RestoreV2"));
        operationBuilder.addInput(prefix.asOutput());
        operationBuilder.addInput(tensorNames.asOutput());
        operationBuilder.addInput(shapeAndSlices.asOutput());
        DataType[] dataTypeArray = new DataType[dtypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(dtypes.get(i2));
        }
        operationBuilder.setAttr("dtypes", dataTypeArray);
        return new RestoreV2(operationBuilder.build());
    }

    public final List<Output<?>> tensors() {
        return this.tensors;
    }

    @Override
    public final Iterator<Operand<Object>> iterator() {
        return this.tensors.iterator();
    }

    private RestoreV2(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("tensors");
        this.tensors = Arrays.asList(operation.outputList(0, n2));
    }
}

