/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseConcat<T>
extends PrimitiveOp {
    private Output<Long> outputIndices;
    private Output<T> outputValues;
    private Output<Long> outputShape;

    public static <T> SparseConcat<T> create(Scope scope, Iterable<Operand<Long>> indices, Operand<T> values, Iterable<Operand<Long>> shapes, Long concatDim) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseConcat", scope.makeOpName("SparseConcat"));
        operationBuilder.addInputList(Operands.asOutputs(indices));
        operationBuilder.addInput(values.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(shapes));
        operationBuilder.setAttr("concat_dim", concatDim);
        return new SparseConcat<T>(operationBuilder.build());
    }

    public final Output<Long> outputIndices() {
        return this.outputIndices;
    }

    public final Output<T> outputValues() {
        return this.outputValues;
    }

    public final Output<Long> outputShape() {
        return this.outputShape;
    }

    private SparseConcat(Operation operation) {
        super(operation);
        this.outputIndices = operation.output(0);
        this.outputValues = operation.output(1);
        this.outputShape = operation.output(2);
    }
}

