/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Stage
extends PrimitiveOp {
    public static Stage create(Scope scope, Iterable<Operand<?>> values, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Stage", scope.makeOpName("Stage"));
        operationBuilder.addInputList(Operands.asOutputs(values));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.capacity != null) {
                    operationBuilder.setAttr("capacity", options2.capacity);
                }
                if (options2.memoryLimit != null) {
                    operationBuilder.setAttr("memory_limit", options2.memoryLimit);
                }
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName == null) continue;
                operationBuilder.setAttr("shared_name", options2.sharedName);
            }
        }
        return new Stage(operationBuilder.build());
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options memoryLimit(Long memoryLimit) {
        return new Options().memoryLimit(memoryLimit);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    private Stage(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long capacity;
        private Long memoryLimit;
        private String container;
        private String sharedName;

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options memoryLimit(Long memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

