/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import java.util.Arrays;

public final class TextFormatParseLocation {
    public static final TextFormatParseLocation EMPTY = new TextFormatParseLocation(-1, -1);
    private final int line;
    private final int column;

    static TextFormatParseLocation create(int line, int column) {
        if (line == -1 && column == -1) {
            return EMPTY;
        }
        if (line < 0 || column < 0) {
            throw new IllegalArgumentException(String.format("line and column values must be >= 0: line %d, column: %d", line, column));
        }
        return new TextFormatParseLocation(line, column);
    }

    private TextFormatParseLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public final String toString() {
        return String.format("ParseLocation{line=%d, column=%d}", this.line, this.column);
    }

    public final boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof TextFormatParseLocation)) {
            return false;
        }
        TextFormatParseLocation textFormatParseLocation = (TextFormatParseLocation)o2;
        return this.line == textFormatParseLocation.getLine() && this.column == textFormatParseLocation.getColumn();
    }

    public final int hashCode() {
        int[] nArray = new int[]{this.line, this.column};
        return Arrays.hashCode(nArray);
    }
}

