/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassClassPath;
import ai.h2o.javassist.ClassPath;
import ai.h2o.javassist.ClassPathList;
import ai.h2o.javassist.DirClassPath;
import ai.h2o.javassist.JarClassPath;
import ai.h2o.javassist.JarDirClassPath;
import ai.h2o.javassist.LoaderClassPath;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.ClassFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

final class ClassPoolTail {
    protected ClassPathList pathList = null;

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[class path: ");
        ClassPathList classPathList = this.pathList;
        while (classPathList != null) {
            stringBuffer.append(classPathList.path.toString());
            stringBuffer.append(File.pathSeparatorChar);
            classPathList = classPathList.next;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public final synchronized ClassPath insertClassPath(ClassPath cp) {
        this.pathList = new ClassPathList(cp, this.pathList);
        return cp;
    }

    public final synchronized ClassPath appendClassPath(ClassPath cp) {
        ClassPathList classPathList = new ClassPathList(cp, null);
        ClassPathList classPathList2 = this.pathList;
        if (classPathList2 == null) {
            this.pathList = classPathList;
        } else {
            while (classPathList2.next != null) {
                classPathList2 = classPathList2.next;
            }
            classPathList2.next = classPathList;
        }
        return cp;
    }

    public final synchronized void removeClassPath(ClassPath cp) {
        ClassPathList classPathList = this.pathList;
        if (classPathList != null) {
            if (classPathList.path == cp) {
                this.pathList = classPathList.next;
                return;
            }
            while (classPathList.next != null) {
                if (classPathList.next.path == cp) {
                    classPathList.next = classPathList.next.next;
                    continue;
                }
                classPathList = classPathList.next;
            }
        }
    }

    public final ClassPath appendSystemPath() {
        if (ClassFile.MAJOR_VERSION < 53) {
            return this.appendClassPath(new ClassClassPath());
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return this.appendClassPath(new LoaderClassPath(classLoader));
    }

    public final ClassPath insertClassPath(String pathname) throws NotFoundException {
        return this.insertClassPath(ClassPoolTail.makePathObject(pathname));
    }

    public final ClassPath appendClassPath(String pathname) throws NotFoundException {
        return this.appendClassPath(ClassPoolTail.makePathObject(pathname));
    }

    private static ClassPath makePathObject(String pathname) throws NotFoundException {
        String string = pathname.toLowerCase();
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            return new JarClassPath(pathname);
        }
        int n2 = pathname.length();
        if (n2 > 2 && pathname.charAt(n2 - 1) == '*' && (pathname.charAt(n2 - 2) == '/' || pathname.charAt(n2 - 2) == File.separatorChar)) {
            String string2 = pathname.substring(0, n2 - 2);
            return new JarDirClassPath(string2);
        }
        return new DirClassPath(pathname);
    }

    final void writeClassfile(String classname, OutputStream out) throws NotFoundException, IOException, CannotCompileException {
        InputStream inputStream = this.openClassfile(classname);
        if (inputStream == null) {
            throw new NotFoundException(classname);
        }
        try {
            ClassPoolTail.copyStream(inputStream, out);
            return;
        }
        finally {
            inputStream.close();
        }
    }

    final InputStream openClassfile(String classname) throws NotFoundException {
        ClassPathList classPathList = this.pathList;
        InputStream inputStream = null;
        NotFoundException notFoundException = null;
        while (classPathList != null) {
            block5: {
                try {
                    inputStream = classPathList.path.openClassfile(classname);
                }
                catch (NotFoundException notFoundException2) {
                    if (notFoundException != null) break block5;
                    notFoundException = notFoundException2;
                }
            }
            if (inputStream == null) {
                classPathList = classPathList.next;
                continue;
            }
            return inputStream;
        }
        if (notFoundException != null) {
            throw notFoundException;
        }
        return null;
    }

    public final URL find(String classname) {
        ClassPathList classPathList = this.pathList;
        while (classPathList != null) {
            URL uRL = classPathList.path.find(classname);
            if (uRL == null) {
                classPathList = classPathList.next;
                continue;
            }
            return uRL;
        }
        return null;
    }

    public static byte[] readStream(InputStream fin) throws IOException {
        byte[][] byArrayArray = new byte[8][];
        int n2 = 4096;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3;
            byArrayArray[i2] = new byte[n2];
            int n4 = 0;
            do {
                if ((n3 = fin.read(byArrayArray[i2], n4, n2 - n4)) >= 0) continue;
                byte[] byArray = new byte[n2 - 4096 + n4];
                int n5 = 0;
                for (int i3 = 0; i3 < i2; ++i3) {
                    int n6 = n5;
                    System.arraycopy(byArrayArray[i3], 0, byArray, n6, n6 + 4096);
                    int n7 = n5;
                    n5 = n7 + n7 + 4096;
                }
                System.arraycopy(byArrayArray[i2], 0, byArray, n5, n4);
                return byArray;
            } while ((n4 += n3) < n2);
            n2 <<= 1;
        }
        throw new IOException("too much data");
    }

    public static void copyStream(InputStream fin, OutputStream fout) throws IOException {
        int n2 = 4096;
        byte[] byArray = null;
        for (int i2 = 0; i2 < 64; ++i2) {
            int n3;
            if (i2 < 8) {
                byArray = new byte[n2 <<= 1];
            }
            int n4 = 0;
            do {
                if ((n3 = fin.read(byArray, n4, n2 - n4)) >= 0) continue;
                fout.write(byArray, 0, n4);
                return;
            } while ((n4 += n3) < n2);
            fout.write(byArray);
        }
        throw new IOException("too much data");
    }
}

