/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.NotFoundException;

final class CtArray
extends CtClass {
    protected ClassPool pool;
    private CtClass[] interfaces = null;

    CtArray(String name, ClassPool cp) {
        super(name);
        this.pool = cp;
    }

    @Override
    public final ClassPool getClassPool() {
        return this.pool;
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public final int getModifiers() {
        int n2 = 16;
        try {
            n2 = 0x10 | this.getComponentType().getModifiers() & 7;
        }
        catch (NotFoundException notFoundException) {}
        return n2;
    }

    @Override
    public final CtClass[] getInterfaces() throws NotFoundException {
        if (this.interfaces == null) {
            Class<?>[] classArray = Object[].class.getInterfaces();
            this.interfaces = new CtClass[classArray.length];
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                this.interfaces[i2] = this.pool.get(classArray[i2].getName());
            }
        }
        return this.interfaces;
    }

    @Override
    public final boolean subtypeOf(CtClass clazz) throws NotFoundException {
        if (super.subtypeOf(clazz)) {
            return true;
        }
        String string = clazz.getName();
        if (string.equals("java.lang.Object")) {
            return true;
        }
        CtClass[] ctClassArray = this.getInterfaces();
        for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
            if (!ctClassArray[i2].subtypeOf(clazz)) continue;
            return true;
        }
        return clazz.isArray() && this.getComponentType().subtypeOf(clazz.getComponentType());
    }

    @Override
    public final CtClass getComponentType() throws NotFoundException {
        String string = this.getName();
        return this.pool.get(string.substring(0, string.length() - 2));
    }

    @Override
    public final CtClass getSuperclass() throws NotFoundException {
        return this.pool.get("java.lang.Object");
    }

    @Override
    public final CtMethod[] getMethods() {
        try {
            return this.getSuperclass().getMethods();
        }
        catch (NotFoundException notFoundException) {
            return super.getMethods();
        }
    }

    @Override
    public final CtMethod getMethod(String name, String desc) throws NotFoundException {
        return this.getSuperclass().getMethod(name, desc);
    }

    @Override
    public final CtConstructor[] getConstructors() {
        try {
            return this.getSuperclass().getConstructors();
        }
        catch (NotFoundException notFoundException) {
            return super.getConstructors();
        }
    }
}

