/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassMap;
import ai.h2o.javassist.CtBehavior;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;

public final class CtConstructor
extends CtBehavior {
    protected CtConstructor(MethodInfo minfo, CtClass declaring) {
        super(declaring, minfo);
    }

    public CtConstructor(CtClass[] parameters, CtClass declaring) {
        this((MethodInfo)null, declaring);
        ConstPool constPool = declaring.getClassFile2().getConstPool();
        String string = Descriptor.ofConstructor(parameters);
        this.methodInfo = new MethodInfo(constPool, "<init>", string);
        this.setModifiers(1);
    }

    public CtConstructor(CtConstructor src, CtClass declaring, ClassMap map) throws CannotCompileException {
        this((MethodInfo)null, declaring);
        this.copy(src, true, map);
    }

    public final boolean isConstructor() {
        return this.methodInfo.isConstructor();
    }

    public final boolean isClassInitializer() {
        return this.methodInfo.isStaticInitializer();
    }

    @Override
    public final String getLongName() {
        return this.getDeclaringClass().getName() + (this.isConstructor() ? Descriptor.toString(this.getSignature()) : ".<clinit>()");
    }

    @Override
    public final String getName() {
        if (this.methodInfo.isStaticInitializer()) {
            return "<clinit>";
        }
        return this.declaringClass.getSimpleName();
    }

    @Override
    public final boolean isEmpty() {
        CodeAttribute codeAttribute = this.getMethodInfo2().getCodeAttribute();
        if (codeAttribute == null) {
            return false;
        }
        ConstPool constPool = codeAttribute.getConstPool();
        CodeIterator codeIterator = codeAttribute.iterator();
        try {
            block7: {
                block6: {
                    int n2;
                    CodeIterator codeIterator2 = codeIterator;
                    int n3 = codeIterator2.byteAt(codeIterator2.next());
                    if (n3 == 177) break block6;
                    if (n3 != 42) break block7;
                    CodeIterator codeIterator3 = codeIterator;
                    int n4 = codeIterator3.next();
                    if (codeIterator3.byteAt(n4) != 183 || (n2 = constPool.isConstructor(this.getSuperclassName(), codeIterator.u16bitAt(n4 + 1))) == 0 || !"()V".equals(constPool.getUtf8Info(n2))) break block7;
                    CodeIterator codeIterator4 = codeIterator;
                    if (codeIterator4.byteAt(codeIterator4.next()) != 177 || codeIterator.hasNext()) break block7;
                }
                return true;
            }
            return false;
        }
        catch (BadBytecode badBytecode) {
            return false;
        }
    }

    private String getSuperclassName() {
        ClassFile classFile = this.declaringClass.getClassFile2();
        return classFile.getSuperclass();
    }

    public final boolean callsSuper() throws CannotCompileException {
        CodeAttribute codeAttribute = this.methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            CodeIterator codeIterator = codeAttribute.iterator();
            try {
                int n2 = codeIterator.skipSuperConstructor();
                return n2 >= 0;
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
        return false;
    }

    @Override
    public final void setBody(String src) throws CannotCompileException {
        if (src == null) {
            src = this.isClassInitializer() ? ";" : "super();";
        }
        super.setBody(src);
    }

    public final void setBody(CtConstructor src, ClassMap map) throws CannotCompileException {
        CtConstructor.setBody0(src.declaringClass, src.methodInfo, this.declaringClass, this.methodInfo, map);
    }

    public final void insertBeforeBody(String src) throws CannotCompileException {
        CtClass ctClass = this.declaringClass;
        ctClass.checkModify();
        if (this.isClassInitializer()) {
            throw new CannotCompileException("class initializer");
        }
        CodeAttribute codeAttribute = this.methodInfo.getCodeAttribute();
        CodeIterator codeIterator = codeAttribute.iterator();
        Bytecode bytecode = new Bytecode(this.methodInfo.getConstPool(), codeAttribute.getMaxStack(), codeAttribute.getMaxLocals());
        bytecode.setStackDepth(codeAttribute.getMaxStack());
        Javac javac = new Javac(bytecode, ctClass);
        try {
            javac.recordParams(this.getParameterTypes(), false);
            javac.compileStmnt(src);
            codeAttribute.setMaxStack(bytecode.getMaxStack());
            codeAttribute.setMaxLocals(bytecode.getMaxLocals());
            codeIterator.skipConstructor();
            int n2 = codeIterator.insertEx(bytecode.get());
            codeIterator.insert(bytecode.getExceptionTable(), n2);
            this.methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    @Override
    final int getStartPosOfBody(CodeAttribute ca) throws CannotCompileException {
        CodeIterator codeIterator = ca.iterator();
        try {
            codeIterator.skipConstructor();
            return codeIterator.next();
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    public final CtMethod toMethod(String name, CtClass declaring) throws CannotCompileException {
        return this.toMethod(name, declaring, null);
    }

    public final CtMethod toMethod(String name, CtClass declaring, ClassMap map) throws CannotCompileException {
        MethodInfo methodInfo;
        CodeAttribute codeAttribute;
        CtMethod ctMethod = new CtMethod(null, declaring);
        ctMethod.copy(this, false, map);
        if (this.isConstructor() && (codeAttribute = (methodInfo = ctMethod.getMethodInfo2()).getCodeAttribute()) != null) {
            CtConstructor.removeConsCall(codeAttribute);
            try {
                this.methodInfo.rebuildStackMapIf6(declaring.getClassPool(), declaring.getClassFile2());
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
        ctMethod.setName(name);
        return ctMethod;
    }

    private static void removeConsCall(CodeAttribute ca) throws CannotCompileException {
        CodeIterator codeIterator = ca.iterator();
        try {
            int n2 = codeIterator.skipConstructor();
            if (n2 >= 0) {
                int n3 = codeIterator.u16bitAt(n2 + 1);
                String string = ca.getConstPool().getMethodrefType(n3);
                int n4 = Descriptor.numOfParameters(string) + 1;
                if (n4 > 3) {
                    n2 = codeIterator.insertGapAt((int)n2, (int)(n4 - 3), (boolean)false).position;
                }
                codeIterator.writeByte(87, n2++);
                codeIterator.writeByte(0, n2);
                codeIterator.writeByte(0, n2 + 1);
                Descriptor.Iterator iterator = new Descriptor.Iterator(string);
                while (true) {
                    iterator.next();
                    if (!iterator.isParameter()) break;
                    codeIterator.writeByte(iterator.is2byte() ? 88 : 87, n2++);
                }
            }
            return;
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }
}

